package com.tcm.system.user.service.impl;

import com.pangding.web.util.RSAUtils;
import com.tcm.system.authority.dao.TcmRoleAuthorityDao;
import com.tcm.system.authority.service.TcmAuthorityService;
import com.tcm.system.authority.vo.req.TcmRoleAuthorityReqVo;
import com.tcm.system.authority.vo.res.TcmAuthorityListByLevelResVo;
import com.tcm.system.user.service.LoginService;
import com.tcm.system.user.service.TokenService;
import com.tcm.system.user.service.UserService;
import com.tcm.system.user.service.ValidateCodeService;
import com.tcm.system.user.vo.RsaContant;
import com.tcm.system.user.vo.TcmLoginTokenVo;
import com.tcm.system.user.vo.req.TcmUserReqVo;
import com.tcm.system.user.vo.req.UserLoginReqVo;
import com.tcm.system.user.vo.res.TcmUserResVo;
import com.tcm.system.user.vo.res.UserLoginResVo;
import com.yanzuoguang.token.TokenHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.JsonHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class LoginServiceImpl implements LoginService {

    private ValidateCodeService validateCodeService;
    private UserService userService;
    private TokenService tokenService;
    private TcmAuthorityService tcmAuthorityService;
    private RsaContant rsaContant;

    public LoginServiceImpl(ValidateCodeService validateCodeService,
                            UserService userService, TokenService tokenService,
                            TcmAuthorityService tcmAuthorityService, RsaContant rsaContant) {
        this.validateCodeService = validateCodeService;
        this.userService = userService;
        this.tokenService = tokenService;
        this.tcmAuthorityService = tcmAuthorityService;
        this.rsaContant = rsaContant;
    }

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,
     *
     * @param reqVo
     * @return
     */
    @Override
    public UserLoginResVo login(UserLoginReqVo reqVo){
        // 当输入用户名和密码时,检测验证码
        List<String> items = new ArrayList<>();
        items.add(reqVo.getAccountOrPhone());
        items.add(reqVo.getPassword());
        validateCodeService.validate(reqVo.getCodeId(), reqVo.getCodeValue(), items);

        TcmUserReqVo userReqVo = new TcmUserReqVo();
        userReqVo.setLoginAccount(reqVo.getAccountOrPhone());
        TcmUserResVo userVo = userService.queryUser(userReqVo);
        if (StringHelper.isEmpty(userVo)) {
            throw new CodeException("用户名不存在");
        }
        try{
            /*通过私钥将rsa加密的密码解密*/
            String  password = RSAUtils.decryptionByPrivateKey(reqVo.getPassword(), rsaContant.getPrivateKey());
            if (!(StringHelper.md5(password).equals(userVo.getPassword()))) {
                throw new CodeException("用户名或密码错误");
            }
        }catch (Exception e){
            throw new CodeException(e.getMessage());
        }

        String token = createToken(reqVo.getAccountOrPhone());

        // 登录返回参数
        UserLoginResVo resVo = new UserLoginResVo();
        resVo.setToken(token);
        resVo.setTcmUserVo(userVo);

        // 保存登录token
        TcmLoginTokenVo loginVo = new TcmLoginTokenVo();
        loginVo.setToken(token);
        loginVo.setDataPwd(token);
        loginVo.setData(JsonHelper.serialize(reqVo));
        loginVo.setExpairTime(DateHelper.getNow());
        tokenService.save(loginVo);
        // 输出结果
        TokenHelper.write(token, loginVo);

        reqVo.setToken(token);

        /*获取用户权限列表*/
        TcmRoleAuthorityReqVo roleAuthorityGetReqVo = new TcmRoleAuthorityReqVo();
        roleAuthorityGetReqVo.setUserId(userVo.getUserId());
        List<TcmAuthorityListByLevelResVo> roleAuthorityVoList = tcmAuthorityService.findAuthorityListByLevel(roleAuthorityGetReqVo);
        resVo.setAuthorityListByLevel(roleAuthorityVoList);

        resVo.setCode("00");
        return resVo;
    }

    public String createToken(String accountOrPhone){
        String token = "";
        try{
            token = RSAUtils.encryptionByPublicKey(accountOrPhone, rsaContant.getPublickey());
            token = StringHelper.md5(token);
        }catch (Exception e){

        }
        return token;
    }
}
