package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.RoleAuthorityDao;
import com.pangding.web.authority.dao.AuthorityDao;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.AuthorityService;
import com.pangding.web.authority.vo.*;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangjinyao
 */
@Service
public class AuthorityServiceImpl implements AuthorityService {

    @Autowired
    AuthorityDao authorityDao;

    @Autowired
    RoleAuthorityDao roleAuthorityDao;

    @Override
    public void save(AuthorityVo authorityVo) {
        this.checkValid(authorityVo);
        authorityVo.setId(StringHelper.getNewID());
        authorityDao.create(authorityVo);
    }

    @Override
    public void update(AuthorityVo authorityVo) {
        this.checkValid(authorityVo);
        authorityDao.update(authorityVo);
    }

    @Override
    public void checkValid(AuthorityVo authorityVo) {
        authorityDao.checkValid(authorityVo);
    }

    @Override
    public AuthorityVo getAuthorityById(WebAuthorityReqVo reqVo) {
        AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
        authorityGetReqVo.setId(reqVo.getId());
        AuthorityVo authorityVo = authorityDao.getAuthority(authorityGetReqVo);
        if (authorityVo == null){
            throw new CodeException("该权限不存在");
        }
        return authorityVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteAuthorityById(WebAuthorityReqVo reqVo) {
        AuthorityVo authorityVo = new AuthorityVo();
        authorityVo.setId(reqVo.getId());
        authorityDao.remove(authorityVo);

        RoleAuthorityGetReqVo roleAuthorityGetReqVo = new RoleAuthorityGetReqVo();
        roleAuthorityGetReqVo.setAuthorityId(reqVo.getId());
        List<RoleAuthorityVo> roleAuthorityList = roleAuthorityDao.getRoleAuthorityList(roleAuthorityGetReqVo);
        for (RoleAuthorityVo roleAuthority:roleAuthorityList) {
            roleAuthorityDao.remove(roleAuthority);
        }

        AuthorityGetReqVo reqVo1 = new AuthorityGetReqVo();
        reqVo1.setPid(reqVo.getId());
        List<AuthorityVo> childList = authorityDao.getAuthoritys(reqVo1);
        if (childList != null && childList.size() != 0){
            for (AuthorityVo child:childList) {
                WebAuthorityReqVo reqVo2 = new WebAuthorityReqVo();
                reqVo2.setId(child.getId());
                this.deleteAuthorityById(reqVo2);
            }
        }
    }


    @Override
    public PageSizeData<WebAuthorityResVo> getWebAuthorityResVoList(ListAuthorityReqVo reqVo) {
        PageSizeData<AuthorityVo> authorityVoPageSizeData = authorityDao.getAuthorityList(reqVo);
        PageSizeData<WebAuthorityResVo> webAuthorityResVoPageSizeData = new PageSizeData();
        List<AuthorityVo> authorityVoList = authorityVoPageSizeData.getList();
        if (authorityVoList == null || authorityVoList.size() == 0){
            throw new CodeException("没有更多权限");
        }
        List<WebAuthorityResVo> webAuthorityResVoList = new ArrayList(authorityVoList.size());
        for (AuthorityVo authorityVo:authorityVoList) {
            WebAuthorityResVo resVo = new WebAuthorityResVo();
            resVo.setUrl(authorityVo.getUrl());
            resVo.setType(authorityVo.getType());
            resVo.setRemark(authorityVo.getRemark());
            resVo.setPid(authorityVo.getPid());
            resVo.setOpenMode(authorityVo.getOpenMode());
            resVo.setName(authorityVo.getName());
            resVo.setId(authorityVo.getId());
            resVo.setCreateTime(authorityVo.getCreateTime());
            resVo.setAlias(authorityVo.getAlias());

            webAuthorityResVoList.add(resVo);
        }
        webAuthorityResVoPageSizeData.setPageSize(authorityVoPageSizeData.getPageSize());
        webAuthorityResVoPageSizeData.setPageIndex(authorityVoPageSizeData.getPageIndex());
        webAuthorityResVoPageSizeData.setPageTotal(authorityVoPageSizeData.getPageTotal());
        webAuthorityResVoPageSizeData.setList(webAuthorityResVoList);

        return webAuthorityResVoPageSizeData;
    }
}
