package com.tcm.common.dao;

import com.tcm.util.area.req.FloorAreaLoadPageReqVo;
import com.tcm.util.area.req.FloorAreaReqVo;
import com.tcm.util.area.res.FloorAreaResVo;
import com.yanzuoguang.dao.BaseDao;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

public interface FloorAreaDao extends BaseDao {
    /**
     * 根据排序加载
     * @param areaReqVo
     * @return
     */
    List<FloorAreaResVo> loadBySort(FloorAreaReqVo areaReqVo);

    /**
     * 加载区域信息
     * @param areaVo
     * @return
     */
    FloorAreaResVo loadInfo(FloorAreaReqVo areaVo);

    /**
     * 分页加载区域
     * @param req
     * @return
     */
    PageSizeData<FloorAreaResVo> loadByPage(FloorAreaLoadPageReqVo req);
}
