package com.tcm.product.service.impl;

import com.tcm.common.service.ImageService;
import com.tcm.product.dao.ProductCategoryDao;
import com.tcm.product.dao.ProductDao;
import com.tcm.product.dao.ProductExtendDao;
import com.tcm.product.service.ProductService;
import com.tcm.util.common.ImageVo;
import com.tcm.util.common.req.ImageReqVo;
import com.tcm.util.common.res.ImageResVo;
import com.tcm.util.product.ProductExtendVo;
import com.tcm.util.product.ProductVo;
import com.tcm.util.product.req.ProductLoadPageReqVo;
import com.tcm.util.product.req.ProductReqVo;
import com.tcm.util.product.res.ProductResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.MapHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
public class ProductServiceImpl implements ProductService {

    private final ProductDao productDao;
    private final ProductExtendDao productExtendDao;
    private final ProductCategoryDao productCategoryDao;
    private final ImageService imageService;

    public ProductServiceImpl(ProductDao productDao,
                              ProductExtendDao productExtendDao,
                              ProductCategoryDao productCategoryDao,
                              ImageService imageService) {
        this.productDao = productDao;
        this.productExtendDao = productExtendDao;
        this.productCategoryDao = productCategoryDao;
        this.imageService = imageService;
    }


    @Override
    public String save(ProductReqVo req) {
        if (StringHelper.isEmpty(req.getProductId())) {
            //新增
            ProductVo productVo = new ProductVo();
            ObjectHelper.writeWithFrom(productVo, req);
            String productId = StringHelper.getNewID();
            productVo.setProductId(productId);
            productVo.setCreateTime(DateHelper.getNow());
            productDao.create(productVo);

            ProductExtendVo productExtendVo = new ProductExtendVo();
            ObjectHelper.writeWithFrom(productExtendVo, req.getProductExtendVo());
            productExtendVo.setProductId(productId);
            productExtendVo.setProductExtendId(StringHelper.getNewID());
            productExtendVo.setCreateTime(DateHelper.getNow());
            productExtendDao.create(productExtendVo);
            //图片保存
            saveImageList(req.getImageList(), productId);
            return productId;
        } else {
            ProductVo productVo = new ProductVo();
            productVo.setProductId(req.getProductId());
            ProductVo load = productDao.load(productVo, ProductVo.class);
            ObjectHelper.writeWithFrom(load, req);
            load.setUpdateTime(DateHelper.getNow());
            productDao.update(load);
            //保存图片
            saveImageList(req.getImageList(), req.getProductId());


            ProductExtendVo productExtendVo = new ProductExtendVo();
            productExtendVo.setProductId(req.getProductId());
            productExtendVo.setLanguageType(req.getProductExtendVo().getLanguageType());
            ProductExtendVo loadExtend = productExtendDao.load(productExtendVo, ProductExtendVo.class);
            if (StringHelper.isEmpty(loadExtend)) {
                //新增
                ObjectHelper.writeWithFrom(productExtendVo, req.getProductExtendVo());
                productExtendVo.setProductExtendId(StringHelper.getNewID());
                productExtendVo.setCreateTime(DateHelper.getNow());
                productExtendDao.create(productExtendVo);
            } else {
                ObjectHelper.writeWithFrom(loadExtend, req.getProductExtendVo());
                loadExtend.setUpdateTime(DateHelper.getNow());
                productExtendDao.update(loadExtend);
            }

            return req.getProductId();
        }

    }

    private void saveImageList(List<ImageVo> imageList, String productId) {
        if (imageList.size() > 0) {
            //删除之前的图片
            ImageReqVo imageReqVo = new ImageReqVo();
            imageReqVo.setRelationId(productId);
            imageService.remove(imageReqVo);
            //保存图片
            List<ImageVo> saveList = new ArrayList<>();
            for (ImageVo imageVo : imageList) {
                ImageReqVo imageSave = new ImageReqVo();
                imageSave.setImageUrl(imageVo.getImageUrl());
                saveList.add(imageSave);
            }
            imageReqVo.setImageStatus(0);
            imageReqVo.setImageType(0);
            imageReqVo.setRelationId(productId);
            imageReqVo.setImageList(saveList);
            imageService.saveList(imageReqVo);
        }

    }

    @Override
    public ProductResVo load(ProductReqVo req) {
        ProductVo productVo = new ProductVo();
        productVo.setProductId(req.getProductId());
        ProductResVo loadRes = productDao.load(productVo, ProductResVo.class);

        ProductExtendVo productExtendVo = new ProductExtendVo();
        productExtendVo.setProductId(req.getProductId());
        productExtendVo.setLanguageType(req.getLanguageType());
        ProductExtendVo loadExtend = productExtendDao.load(productExtendVo, ProductExtendVo.class);
        loadRes.setProductExtendVo(loadExtend);

        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(req.getProductId());
        List<ImageResVo> imageList = imageService.loadList(imageReqVo);
        loadRes.setImageList(imageList);
        return loadRes;
    }

    @Override
    public PageSizeData<ProductResVo> loadPage(ProductLoadPageReqVo req) {
        PageSizeData<ProductResVo> page = productDao.loadByPage(req);
        ProductExtendVo productExtendVo = new ProductExtendVo();
        ImageReqVo imageReqVo = new ImageReqVo();
        for (ProductResVo res : page.getList()) {
            productExtendVo.setProductId(res.getProductId());
            productExtendVo.setLanguageType(req.getLanguageType());
            ProductExtendVo loadExtend = productExtendDao.load(productExtendVo, ProductExtendVo.class);
            res.setProductExtendVo(loadExtend);
            imageReqVo.setRelationId(res.getProductId());
            List<ImageResVo> imageList = imageService.loadList(imageReqVo);
            res.setImageList(imageList);
        }
        return page;
    }

    @Override
    public String remove(ProductReqVo req) {
        ProductVo productVo = new ProductVo();
        productVo.setProductId(req.getProductId());
        productDao.remove(productVo);
        ProductExtendVo productExtendVo = new ProductExtendVo();
        productExtendVo.setProductId(req.getProductId());
        productExtendDao.remove(productExtendVo);

        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(req.getProductId());
        imageService.remove(imageReqVo);
        return req.getProductId();
    }

    @Override
    public PageSizeData<ProductResVo> displayList(ProductLoadPageReqVo req) {
        PageSizeData<ProductResVo> page = productDao.loadPage(req, ProductResVo.class);
        List<ProductExtendVo> productExtendList = productExtendDao.loadList(req, ProductExtendVo.class);
        Map<String, ProductExtendVo> productExtendVoMap = MapHelper.getMap(productExtendList, ProductExtendVo::getProductId);
        page.getList().forEach(item -> {
            ImageReqVo imageReqVo = new ImageReqVo();
            imageReqVo.setRelationId(item.getProductId());
            item.setImageList(imageService.loadList(imageReqVo));
            ProductExtendVo productExtendVo = productExtendVoMap.get(item.getProductId());
            item.setProductExtendVo(productExtendVo);
            item.setProductName(productExtendVo.getProductName());
        });
        return page;
    }

    @Override
    public String changeStatus(ProductReqVo req) {
        ProductVo productVo = new ProductVo();
        productVo.setProductId(req.getProductId());
        ProductVo load = productDao.load(productVo, ProductVo.class);
        load.setStatus(req.getStatus());
        productDao.update(load);
        return req.getProductId();
    }
}
