package com.tcm.system.api;


import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author zhongjf
 * @description 接口地址配置类
 * @date 2019/5/6
 */
@Component
public class WebChatConfig {
    /*================ 基础配置======**/
    /**
     * 获取access_token的接口地址（GET） 限2000（次/天）
     */
    @Value("${wechat.public.base.accesTokenUrl:https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET}")
    public String accesTokenUrl;
    /**
     * 授权登录地址
     */
    @Value("${wechat.public.base.authrizeUrl:https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect}")
    public String authrizeUrl;
    /**
     * 网页授权通过code获取access_token
     */
    @Value("${wechat.public.base.accessTokenSnsUrl:https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=APPSECRET&code=CODE&grant_type=authorization_code}")
    public String accessTokenSnsUrl;

    /**
     * 获取jsapi_ticket的接口地址（GET） 限2000（次/天）
     */
    @Value("${wechat.public.base.jsapiTicketUrl:dddd}")
    public String jsapiTicketUrl;


    /*================ 中医院小程序配置======**/
    @Value("${wechat.applets.code2Session: https://api.weixin.qq.com/sns/jscode2session?appid=APPID&secret=SECRET&js_code=JSCODE&grant_type=authorization_code}")
    public String code2Session;
    @Value("${wechat.applets.getPaidUnionId: https://api.weixin.qq.com/wxa/getpaidunionid?access_token=ACCESS_TOKEN&openid=OPENID&mch_id=MCH_ID&out_trade_no=OUT_TRADE_NO}")
    public String getPaidUnionId;
    @Value("${wechat.applets.lx.appid: wxe678d5240e98a7b8}")
    public String appletsAppId;
    @Value("${wechat.applets.lx.appSecret:edc0e8778b245a3a4ac11e449ec3f35a}")
    public String appletsAppSecret;



}
