package com.tcm.system.api;

import com.pangding.web.constant.PangdConstant;
import com.pangding.web.vo.applet.pd.AppletVo;
import com.tcm.system.applets.dao.AppletDao;
import com.tcm.system.user.vo.req.AppletUserLoginReqVo;
import com.yanzuoguang.util.helper.HttpHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.codec.CodecException;
import org.springframework.stereotype.Component;

@Component
public class WechatApi {

    @Autowired
    private WebChatConfig webChatConfig;
    @Autowired
    private AppletDao appletDao;


    /**
     * 获取凭据
     * @return
     */
    public String getAccessToken(String wechatType) {
        String result = "";
        String appid = webChatConfig.appletsAppId;
        String secret = webChatConfig.appletsAppSecret;
        try {
            String url = webChatConfig.accesTokenUrl
                    .replace("APPID", appid).replace("APPSECRET", secret);
            result = HttpHelper.get(url);
        } catch (Exception ex) {
            throw new CodecException(ex.getMessage());
        }
        return result;
    }

    /**
     * 小程序获取凭据
     * @return
     */
    public String getAppletsAccessToken() {
        String result = "";
        try {
            String url = webChatConfig.accesTokenUrl
                    .replace("APPID", webChatConfig.appletsAppId)
                    .replace("APPSECRET", webChatConfig.appletsAppSecret);
            result = HttpHelper.get(url);
        } catch (Exception ex) {
            throw new CodecException(ex.getMessage());
        }
        return result;
    }

    /**
     * 小程序登录
     * @param req
     * @return
     */
    public String code2Session(AppletUserLoginReqVo req) {
        String result = "";
        String url= "";
        try {
            // 微信小程序appid默认为胖丁小程序
            String appid = webChatConfig.appletsAppId;
            String secret = webChatConfig.appletsAppSecret;
            // 根据公司或者景区查询该景区的小程序参数
            if(!StringHelper.isEmpty(req.getAppid())){
                AppletVo appletReqVo = new AppletVo();
                appletReqVo.setAppletType(PangdConstant.APPLET_WECHAT);
                appletReqVo.setAppletAppid(req.getAppid());
                AppletVo appletVo = appletDao.load(appletReqVo, AppletVo.class);
                if(!StringHelper.isEmpty(appletVo)){
                    appid = appletVo.getAppletAppid();
                    secret = appletVo.getAppletSecret();
                }
            }
            url = webChatConfig.code2Session
                    .replace("APPID", appid).replace("SECRET", secret)
                    .replace("JSCODE", req.getCode());

            result = HttpHelper.get(url);
        } catch (Exception ex) {
            throw new CodecException(ex.getMessage());
        }
        return result;
    }

//    /**
//     * 小程序登录 TODO
//     * @param req
//     * @return
//     */
//    public String getPaidUnionId(AppletsPaidUnionIdReqVo req) {
//        String result = "";
//        try {
//            String url = webChatConfig.getPaidUnionId
//                    .replace("ACCESS_TOKEN", req.getAccess_token()).replace("OPENID", req.getOpenid())
//                    .replace("MCH_ID", req.getMch_id()).replace("OUT_TRADE_NO", req.getOut_trade_no());
//            result = HttpHelper.get(url);
//        } catch (Exception ex) {
//            throw new CodecException(ex.getMessage());
//        }
//        return result;
//    }


}
