package com.tcm.system.applets.api;

import com.pangding.web.vo.applet.req.GenerateUrlLinkReqVo;
import com.yanzuoguang.util.helper.HttpHelper;
import com.yanzuoguang.util.helper.JsonHelper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.codec.CodecException;
import org.springframework.stereotype.Component;

/**
 * 微信小程序 api
 * @author 唐芳
 */
@Component
public class WechatAppletApi {

    @Value("${wechat.applets.generateUrlLink:https://api.weixin.qq.com/wxa/generate_urllink?access_token=ACCESS_TOKEN}")
    private String generateUrlLinkUrl;


    /**
     *
     * @param req
     * @return
     */
    public String generateUrlLink(String token, GenerateUrlLinkReqVo req) {
        String result = "";
        try {
            String url = generateUrlLinkUrl.replace("ACCESS_TOKEN", token);
            String param = JsonHelper.serialize(req);
            result = HttpHelper.postApplicationJSON(url, param);
        } catch (Exception ex) {
            throw new CodecException(ex.getMessage());
        }
        return result;
    }


}
