package com.tcm.system.applets.dao.impl;

import com.tcm.system.applets.dao.AppletDao;
import com.tcm.system.applets.vo.TcmAppletVo;
import com.tcm.system.applets.vo.req.TcmAppletReqVo;
import com.tcm.system.applets.vo.res.TcmAppletResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class AppletDaoImpl extends BaseDaoImpl implements AppletDao {

    private static final String QUERY_LIST = "QUERY_LIST";

    @Override
    protected void init() {
        // 根据实体生成增删改查语句
        register(TcmAppletVo.class);

        table.add(QUERY_LIST, "SELECT * FROM pd_applet WHERE 1=1 ")
                .add("appletName"," AND applet_name LIKE concat('%', ?,'%') ")
                .add("merchantName"," AND merchant_name LIKE concat('%', ?,'%') ")
                .add("companyName","AND company_name LIKE concat('%', ?,'%') ")
                .add("appletAppid","AND applet_appid = ? ")
                .add("appletType","AND applet_type = ? ");

    }

    @Override
    public PageSizeData<TcmAppletResVo> queryAppletPageList(TcmAppletReqVo req) {
        return this.queryPage(TcmAppletResVo.class, req, QUERY_LIST, req);
    }


}
