package com.tcm.system.applets.service.impl;

import com.tcm.system.applets.dao.AppletDao;
import com.tcm.system.applets.service.AppletService;
import com.tcm.system.applets.vo.TcmAppletVo;
import com.tcm.system.applets.vo.req.TcmAppletReqVo;
import com.tcm.system.applets.vo.res.TcmAppletResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

@Service
public class AppletServiceImpl implements AppletService {

    private AppletDao appletDao;

    public AppletServiceImpl(AppletDao appletDao) {
        this.appletDao = appletDao;
    }

    @Override
    public PageSizeData<TcmAppletResVo> queryAppletPageList(TcmAppletReqVo req) {
        return appletDao.queryAppletPageList(req);
    }

    @Override
    public TcmAppletResVo queryApplet(TcmAppletReqVo req) {
        return appletDao.load(req.getAppletId(), TcmAppletResVo.class);
    }

    @Override
    public String saveApplet(TcmAppletReqVo req) {

//        String appletId = StringHelper.getMD5Id(req.getAppletAppid(), req.getAppletType());

        TcmAppletReqVo appletReqVo = new TcmAppletReqVo();
        appletReqVo.setAppletAppid(req.getAppletAppid());
        appletReqVo.setAppletType(req.getAppletType());
        TcmAppletVo appletResVo = appletDao.load(appletReqVo, TcmAppletVo.class);
        if (StringHelper.isEmpty(appletResVo)) {
            req.setAppletId(req.getAppletAppid());
            appletDao.create(req);
        } else {
            ObjectHelper.writeWithFromClass(appletResVo, req);
            appletDao.update(appletResVo);
        }
        return "处理成功";
    }



}
