package com.tcm.system.applets.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.vo.BaseVo;
import com.yanzuoguang.util.vo.InitDao;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@TableAnnotation("tcm_applet")
@ApiModel(
        description = "小程序配置实体"
)
public class TcmAppletVo extends BaseVo implements InitDao {

    @ApiModelProperty(
            notes = "小程序编号"
    )
    @TableAnnotation("applet_id")
    private String appletId;
    @ApiModelProperty(
            notes = "小程序名称"
    )
    @TableAnnotation("applet_name")
    private String appletName;
    @ApiModelProperty(
            notes = "小程序appid"
    )
    @TableAnnotation("applet_appid")
    private String appletAppid;
    @ApiModelProperty(
            notes = "小程序类型  0 微信  1支付宝"
    )
    @TableAnnotation("applet_type")
    private Integer appletType;
    @ApiModelProperty(
            notes = "商户编号"
    )
    @TableAnnotation("merchant_id")
    private String merchantId;
    @ApiModelProperty(
            notes = "商户名称"
    )
    @TableAnnotation("merchant_name")
    private String merchantName;
    @ApiModelProperty(
            notes = "商户编号"
    )
    @TableAnnotation("company_id")
    private String companyId;
    @ApiModelProperty(
            notes = "商户名称"
    )
    @TableAnnotation("company_name")
    private String companyName;
    @ApiModelProperty(
            notes = "平台私钥"
    )
    @TableAnnotation("private_key")
    private String privateKey;
    @ApiModelProperty(
            notes = "平台公钥"
    )
    @TableAnnotation("public_key")
    private String publicKey;
    @ApiModelProperty(
            notes = "应用私钥"
    )
    @TableAnnotation("applets_private_key")
    private String appletsPrivateKey;
    @ApiModelProperty(
            notes = "应用公钥"
    )
    @TableAnnotation("applets_public_key")
    private String appletsPublicKey;
    @ApiModelProperty(
            notes = "小程序秘钥"
    )
    @TableAnnotation("applet_secret")
    private String appletSecret;
    @ApiModelProperty(
            notes = "抖音小程序授权码"
    )
    @TableAnnotation("authorization_code")
    private String authorizationCode;

    public void init() {
    }

    public String getAppletId() {
        return appletId;
    }

    public void setAppletId(String appletId) {
        this.appletId = appletId;
    }

    public String getAppletName() {
        return appletName;
    }

    public void setAppletName(String appletName) {
        this.appletName = appletName;
    }

    public String getAppletAppid() {
        return appletAppid;
    }

    public void setAppletAppid(String appletAppid) {
        this.appletAppid = appletAppid;
    }

    public Integer getAppletType() {
        return appletType;
    }

    public void setAppletType(Integer appletType) {
        this.appletType = appletType;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getAppletsPrivateKey() {
        return appletsPrivateKey;
    }

    public void setAppletsPrivateKey(String appletsPrivateKey) {
        this.appletsPrivateKey = appletsPrivateKey;
    }

    public String getAppletsPublicKey() {
        return appletsPublicKey;
    }

    public void setAppletsPublicKey(String appletsPublicKey) {
        this.appletsPublicKey = appletsPublicKey;
    }

    public String getAppletSecret() {
        return appletSecret;
    }

    public void setAppletSecret(String appletSecret) {
        this.appletSecret = appletSecret;
    }

    public String getAuthorizationCode() {
        return authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }
}
