package com.tcm.system.applets.web;

import com.tcm.system.applets.service.AppletService;
import com.tcm.system.applets.vo.req.TcmAppletReqVo;
import com.tcm.system.applets.vo.res.TcmAppletResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/applets")
public class AppletController {

    private AppletService appletService;

    public AppletController(AppletService appletService) {
        this.appletService = appletService;
    }

    /**
     * 查询小程序分页列表
     * @param req
     * @return
     */
    @ResponseBody
    @RequestMapping( value = "/queryAppletPageList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查询小程序分页列表", notes = "返回小程序分页列表")
    public ResponseResult<PageSizeData<TcmAppletResVo>> queryAppletPageList(@RequestBody TcmAppletReqVo req) {
        return ResponseResult.result(appletService.queryAppletPageList(req));
    }

    /**
     * 查看小程序详情
     * @param req
     * @return
     */
    @ResponseBody
    @RequestMapping( value = "/queryApplet", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查看小程序详情", notes = "返回小程序详情")
    public ResponseResult<TcmAppletResVo> queryApplet(@RequestBody TcmAppletReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("appletId", req.getAppletId())
                .checkException();
        return ResponseResult.result(appletService.queryApplet(req));
    }

    /**
     * 查看小程序详情
     * @param req
     * @return
     */
    @ResponseBody
    @RequestMapping( value = "/queryAppletByInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查看小程序详情", notes = "返回小程序详情")
    public ResponseResult<TcmAppletResVo> queryAppletByInfo(@RequestBody TcmAppletReqVo req) {
        return ResponseResult.result(appletService.queryApplet(req));
    }

    /**
     * 保存小程序
     * @param req
     * @return
     */
    @ResponseBody
    @RequestMapping( value = "/saveApplet", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "保存小程序", notes = "返回保存小程序结果")
    public ResponseResult<String> saveApplet(@RequestBody TcmAppletReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("appletAppid", req.getAppletAppid())
                .notBlankCheck("appletSecret", req.getAppletSecret())
                .notBlankCheck("appletName", req.getAppletName())
                .notBlankCheck("appletType", req.getAppletType())
                .checkException();
        return ResponseResult.result(appletService.saveApplet(req));
    }



}
