package com.tcm.system.authority.dao.impl;

import com.tcm.system.authority.dao.TcmRoleAuthorityDao;
import com.tcm.system.authority.vo.TcmRoleAuthorityVo;
import com.yanzuoguang.dao.DaoConst;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

/**
 * @author zhangjinyao
 */
@Component
public class TcmRoleAuthorityDaoImpl extends BaseDaoImpl implements TcmRoleAuthorityDao {

    @Override
    protected void init() {
        register(TcmRoleAuthorityVo.class);

        getSql(DaoConst.LOAD).setSql("select a.role_id,b.* " +
                " from tcm_sys_role_authority a  " +
                " RIGHT JOIN tcm_sys_authority b on a.authority_id = b.authority_id {INNER} " +
                " where 1=1 {WHERE} ORDER BY b.pid,b.authority_sort,b.attribute" )
                .add("userId", "AND c.user_id = @userId",
                        "{INNER}", "INNER JOIN tcm_sys_user AS c ON a.role_id = c.role_id")
                .add("roleId", " AND a.role_id = @roleId")
                .add("authorityId", " AND b.authority_id = @authorityId")
                .add("platformType", " AND b.platform_type = @platformType")
        ;

    }

}
