package com.tcm.system.authority.service.impl;

import com.tcm.system.authority.dao.TcmAuthorityDao;
import com.tcm.system.authority.dao.TcmRoleAuthorityDao;
import com.tcm.system.authority.service.TcmAuthorityService;
import com.tcm.system.authority.vo.TcmAuthorityVo;
import com.tcm.system.authority.vo.req.TcmAuthorityPageReqVo;
import com.tcm.system.authority.vo.req.TcmAuthorityReqVo;
import com.tcm.system.authority.vo.req.TcmAuthoritySaveReqVo;
import com.tcm.system.authority.vo.req.TcmRoleAuthorityReqVo;
import com.tcm.system.authority.vo.res.TcmAuthorityListByLevelResVo;
import com.tcm.system.authority.vo.res.TcmAuthorityListResVo;
import com.tcm.system.authority.vo.res.TcmAuthorityResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class TcmAuthorityServiceImpl implements TcmAuthorityService {

    private TcmAuthorityDao tcmAuthorityDao;
    private TcmRoleAuthorityDao tcmRoleAuthorityDao;

    public TcmAuthorityServiceImpl(TcmAuthorityDao tcmAuthorityDao, TcmRoleAuthorityDao tcmRoleAuthorityDao) {
        this.tcmAuthorityDao = tcmAuthorityDao;
        this.tcmRoleAuthorityDao = tcmRoleAuthorityDao;
    }

    /**
     * 获取权限返回信息分页对象
     *
     * @param reqVo
     * @return 权限返回信息分页对象
     */
    @Override
    public PageSizeData<TcmAuthorityResVo> findAuthorityPage(TcmAuthorityPageReqVo reqVo) {

        PageSizeData<TcmAuthorityResVo> authorityVoPageSizeData = tcmAuthorityDao.findAuthorityPage(reqVo);
        return authorityVoPageSizeData;
    }

    /**
     * 查询不分页权限列表
     *
     * @return
     */
    @Override
    public List<TcmAuthorityResVo> findAuthorityList(TcmAuthorityReqVo reqVo) {
        List<TcmAuthorityResVo> authorityVoList = tcmAuthorityDao.findAuthorityList(reqVo);
        if (null == authorityVoList || authorityVoList.isEmpty()) {
            throw new CodeException("暂无权限，请先添加");
        }
        return authorityVoList;
    }

    /**
     * 通过权限表主键获取authorityVo对象
     *
     * @param reqVo 主键
     * @return authorityVo对象
     */
    @Override
    public TcmAuthorityResVo findTcmAuthorityInfo(TcmAuthorityReqVo reqVo) {

        TcmAuthorityResVo authorityVo = tcmAuthorityDao.load(reqVo, TcmAuthorityResVo.class);
        if (StringHelper.isEmpty(authorityVo)) {
            throw new CodeException("该权限不存在");
        }
        return authorityVo;
    }


    @Override
    public TcmAuthorityListResVo findAuthorityListByLevel(TcmRoleAuthorityReqVo reqVo) {
        TcmAuthorityListResVo authorityListResVo = new TcmAuthorityListResVo();
//        // 找到该公司管理员角色
//        RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
//        roleGetReqVo.setCompanyId(reqVo.getCompanyId());
//        roleGetReqVo.setIsAdmin(1);
//        RoleVo roleVo = roleDaoImpl.load(roleGetReqVo, RoleVo.class);
//        if (StringHelper.isEmpty(roleVo)) {
//            throw new CodeException("该公司用户未设置管理员角色");
//        }

//        // 查询该公司管理员角色权限
        TcmRoleAuthorityReqVo tcmRoleAuthorityReqVo = new TcmRoleAuthorityReqVo();
//        tcmRoleAuthorityReqVo.setRoleId(roleVo.getId());
        List<TcmAuthorityListByLevelResVo> allAuthorityList = getListByLevel(tcmRoleAuthorityReqVo);
        authorityListResVo.setAllAuthorityList(allAuthorityList);


        List<TcmAuthorityVo> roleAuthorityList = tcmRoleAuthorityDao.loadList(reqVo, TcmAuthorityVo.class);
        authorityListResVo.setRoleAuthorityList(roleAuthorityList);

        return authorityListResVo;
    }

    public List<TcmAuthorityListByLevelResVo> getListByLevel(TcmRoleAuthorityReqVo req){
        List<TcmAuthorityListByLevelResVo> roleAuthorityVoList = tcmAuthorityDao.loadList(req, TcmAuthorityListByLevelResVo.class);
        return getChildList(roleAuthorityVoList, false);
    }

    /**
     * 保存authorityVo对象数据
     *
     * @param authorityVo authorityVo对象
     * @return 用户id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TcmAuthoritySaveReqVo authorityVo) {
        if (StringHelper.isEmpty(authorityVo.getPid())) {
            authorityVo.setPid("");
        }
        TcmAuthorityReqVo tcmAuthorityReqVo = new TcmAuthorityReqVo();
        tcmAuthorityReqVo.setAuthorityName(authorityVo.getAuthorityName());
        tcmAuthorityReqVo.setAuthorityUrl(authorityVo.getAuthorityUrl());

        TcmAuthorityVo tcmAuthorityResVo = tcmAuthorityDao.load(tcmAuthorityReqVo, TcmAuthorityVo.class);
        if(StringHelper.isEmpty(tcmAuthorityResVo)){
            //TODO 排序需要处理 需要跟默认角色加上权限
            authorityVo.setAuthorityId(StringHelper.getNewID());
            tcmAuthorityDao.create(authorityVo);
        }else{
            ObjectHelper.writeWithFromClass(tcmAuthorityResVo, authorityVo);
            tcmAuthorityDao.update(tcmAuthorityResVo);
        }

    }

    /**
     * 通过权限表主键删除authorityVo对象，并删除权限和角色的对应关系
     * 递归删除其子权限
     *
     * @param reqVo 主键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delAuthority(TcmAuthorityReqVo reqVo) {

        TcmAuthorityResVo authorityVo = tcmAuthorityDao.load(reqVo, TcmAuthorityResVo.class);
        if (StringHelper.isEmpty(authorityVo)) {
            throw new CodeException("该权限不存在");
        }

        TcmAuthorityReqVo reqVo1 = new TcmAuthorityReqVo();
        reqVo1.setPid(authorityVo.getAuthorityId());
        List<TcmAuthorityVo> childList = tcmAuthorityDao.loadList(reqVo1, TcmAuthorityVo.class);
        if (childList != null && !childList.isEmpty()) {
            for (TcmAuthorityVo child : childList) {
                tcmAuthorityDao.remove(child);
            }
        }

        tcmAuthorityDao.remove(authorityVo);

//        RoleAuthorityGetReqVo roleAuthorityGetReqVo = new RoleAuthorityGetReqVo();
//        roleAuthorityGetReqVo.setAuthority(reqVo.getId());
//        List<RoleAuthorityVo> roleAuthorityList = roleAuthorityDao.loadList(roleAuthorityGetReqVo, RoleAuthorityVo.class);
//        for (RoleAuthorityVo roleAuthority : roleAuthorityList) {
//            roleAuthorityDao.remove(roleAuthority);
//        }
    }

//    /**
//     * 将权限新排序后面所有的权限排序+1
//     *
//     * @param authorityVo 权限对象
//     */
//    private void afterPlus(TcmAuthorityVo authorityVo) {
//        TcmAuthorityVo reqVo = new TcmAuthorityVo();
//        reqVo.setPid(authorityVo.getPid());
//        reqVo.setAuthoritySort(authorityVo.getAuthoritySort());
//        reqVo.setAttribute(authorityVo.getAttribute());
//        TcmAuthorityVo authorityVo1 = tcmAuthorityDao.load(reqVo, TcmAuthorityVo.class);
//        if (authorityVo1 != null) {
//            AuthorityAfterReqVo afterReqVo = new AuthorityAfterReqVo();
//            ObjectHelper.writeWithFrom(afterReqVo, authorityVo);
//            List<AuthorityVo> authorityVoList = authorityDao.after(afterReqVo);
//            for (AuthorityVo authorityVo2 : authorityVoList) {
//                Integer sort = authorityVo2.getSort();
//                Integer newSort = sort + 1;
//                authorityVo2.setSort(newSort);
//                authorityDao.update(authorityVo2);
//            }
//        }
//    }
//
//    private void afterSub(AuthorityVo authorityVo) {
//        AuthorityGetReqVo getReqVo = new AuthorityGetReqVo();
//        getReqVo.setId(authorityVo.getId());
//        AuthorityVo authorityVo1 = authorityDao.load(getReqVo, AuthorityVo.class);
//        if (authorityVo1 != null) {
//            AuthorityAfterReqVo afterReqVo = new AuthorityAfterReqVo();
//            ObjectHelper.writeWithFrom(afterReqVo, authorityVo);
//            List<AuthorityVo> authorityVoList = authorityDao.after(afterReqVo);
//            for (AuthorityVo authorityVo2 : authorityVoList) {
//                Integer sort = authorityVo2.getSort();
//                Integer newSort = sort - 1;
//                authorityVo2.setSort(newSort);
//                authorityDao.update(authorityVo2);
//            }
//        }
//    }
//
//
//    private void updateSort(AuthorityVo authorityVo) {
//        AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
//        authorityGetReqVo.setId(authorityVo.getId());
//        AuthorityVo old = authorityDao.load(authorityGetReqVo, AuthorityVo.class);
//        if (old.getSort() > authorityVo.getSort()) {
//            AuthorityBetweenSortReqVo reqVo = new AuthorityBetweenSortReqVo();
//            reqVo.setPid(authorityVo.getPid());
//            reqVo.setSmallSort(authorityVo.getSort());
//            reqVo.setBigSort(old.getSort());
//            reqVo.setAttribute(authorityVo.getAttribute());
//            List<AuthorityVo> authorityVoList = authorityDao.getLessBetween(reqVo);
//            for (AuthorityVo authorityVo1 : authorityVoList) {
//                authorityVo1.setSort(authorityVo1.getSort() + 1);
//                authorityDao.update(authorityVo1);
//            }
//        }
//        if (old.getSort() < authorityVo.getSort()) {
//            AuthorityBetweenSortReqVo reqVo = new AuthorityBetweenSortReqVo();
//            reqVo.setPid(authorityVo.getPid());
//            reqVo.setSmallSort(old.getSort());
//            reqVo.setBigSort(authorityVo.getSort());
//            reqVo.setAttribute(authorityVo.getAttribute());
//            List<AuthorityVo> authorityVoList = authorityDao.getMoreBetween(reqVo);
//            for (AuthorityVo authorityVo1 : authorityVoList) {
//                authorityVo1.setSort(authorityVo1.getSort() - 1);
//                authorityDao.update(authorityVo1);
//            }
//        }
//    }





    public static <T extends TcmAuthorityListByLevelResVo> List<T> getChildList(List<T> list, boolean check) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        Map<String, T> idMap = new HashMap<>(list.size());
        List<T> root = new ArrayList<>();
        // 将所有对象进行映射
        for (T vo : list) {
            String id = vo.getAuthorityId();
            idMap.put(id, vo);
        }

        // 组合成父子级关系
        for (T vo : list) {
            String pid = StringHelper.getFirst(vo.getPid());
            String id = vo.getAuthorityId();
            //当前对象的父对象不存在则创建一个临时的父对象
            if (StringHelper.isEmpty(pid)) {
                root.add(vo);
            } else if (idMap.containsKey(pid)) {
//                List<TcmAuthorityListByLevelResVo> childList = idMap.get(pid).getChildList();
//                if (null == childList) {
//                    childList = new ArrayList<>();
//                }
//                childList.add(vo);
                idMap.get(pid).getChildList().add(vo);
            } else if (check) {
                throw new CodeException(String.format("存在数据不合理,子节点[%s]父id[%s]不存在", id, pid));
            }
        }
        return root;
    }


}
