package com.tcm.system.authority.web;

import com.tcm.system.authority.service.TcmAuthorityService;
import com.tcm.system.authority.vo.req.TcmAuthorityPageReqVo;
import com.tcm.system.authority.vo.req.TcmAuthorityReqVo;
import com.tcm.system.authority.vo.req.TcmAuthoritySaveReqVo;
import com.tcm.system.authority.vo.req.TcmRoleAuthorityReqVo;
import com.tcm.system.authority.vo.res.TcmAuthorityListResVo;
import com.tcm.system.authority.vo.res.TcmAuthorityResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/authority")
@Api(value = "权限")
public class TcmAuthorityController {

    private TcmAuthorityService tcmAuthorityService;

    public TcmAuthorityController(TcmAuthorityService tcmAuthorityService) {
        this.tcmAuthorityService = tcmAuthorityService;
    }

    /**
     * 查询分页权限列表
     * @return
     */
    @RequestMapping(value = "/findAuthorityPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<TcmAuthorityResVo>> findAuthorityPage(@RequestBody TcmAuthorityPageReqVo reqVo){
        return ResponseResult.result(tcmAuthorityService.findAuthorityPage(reqVo));
    }

    /**
     * 查询权限列表,不分页，不分层级
     * @return
     */
    @RequestMapping(value = "/findAuthorityList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<List<TcmAuthorityResVo>> findAuthorityList(@RequestBody TcmAuthorityReqVo reqVo){
        return ResponseResult.result(tcmAuthorityService.findAuthorityList(reqVo));
    }

    /**
     * 查询权限详情
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/findAuthority", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<TcmAuthorityResVo> findAuthority(@RequestBody TcmAuthorityReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("anthorityId",reqVo.getAuthorityId())
                .checkException();
        return ResponseResult.result(tcmAuthorityService.findTcmAuthorityInfo(reqVo));
    }

    /**
     * 按等级返回权限列表
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/findAuthorityListByLevel", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<TcmAuthorityListResVo> findAuthorityListByLevel(@RequestBody TcmRoleAuthorityReqVo reqVo){
        return ResponseResult.result(tcmAuthorityService.findAuthorityListByLevel(reqVo));
    }

    /**
     * 保存权限
     * @param req
     * @return
     */
    @RequestMapping(value = "/saveAuthority", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> saveAuthority(@RequestBody TcmAuthoritySaveReqVo req){
        CheckerHelper.newInstance()
                .notBlankCheck("authorityName",req.getAuthorityName())
                .notBlankCheck("authorityType", req.getAuthorityType())
                .notBlankCheck("authorityAlias", req.getAuthorityAlias())
                .notBlankCheck("openMode",req.getOpenMode())
                .notBlankCheck("authoritySort", req.getAuthoritySort())
                .checkException();
        tcmAuthorityService.save(req);
        return ResponseResult.result("处理成功");
    }

    /**
     * 删除权限
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult delete(@RequestBody TcmAuthorityReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("anthorityId",reqVo.getAuthorityId())
                .checkException();
        tcmAuthorityService.delAuthority(reqVo);
        return new ResponseResult();
    }

}
