package com.tcm.system.position.dao.impl;

import com.tcm.system.position.dao.PositionDao;
import com.tcm.system.position.vo.PositionVo;
import com.tcm.system.position.vo.req.PositionPageReqVo;
import com.tcm.system.position.vo.res.PositionListResVo;
import com.tcm.system.role.vo.req.TcmRolePageReqVo;
import com.tcm.system.role.vo.res.TcmRoleListResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class PositionDaoImpl extends BaseDaoImpl implements PositionDao {

    private static final String QUERY_LIST = "QUERY_LIST";

    @Override
    protected void init() {
        register(PositionVo.class);

        table.add(QUERY_LIST, "select * from tcm_sys_position a " +
                " where 1=1 {WHERE}")
                .add("positionId", " and a.position_id = ? ")
                .add("positionName", " and a.position_name LIKE concat(?,'%') ");
    }


    @Override
    public PageSizeData<PositionListResVo> findPositionPage(PositionPageReqVo req) {
        return this.queryPage(PositionListResVo.class, req, QUERY_LIST, req);
    }


    @Override
    public List<PositionListResVo> findPositionList(PositionPageReqVo req) {
        return this.query(PositionListResVo.class, QUERY_LIST, req);
    }

}
