package com.tcm.system.position.service.impl;

import com.tcm.system.position.dao.PositionDao;
import com.tcm.system.position.service.PositionService;
import com.tcm.system.position.vo.PositionVo;
import com.tcm.system.position.vo.req.PositionPageReqVo;
import com.tcm.system.position.vo.req.PositionSaveReqVo;
import com.tcm.system.position.vo.res.PositionListResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class PositionServiceImpl implements PositionService {

    private PositionDao positionDao;

    public PositionServiceImpl(PositionDao positionDao) {
        this.positionDao = positionDao;
    }

    public PageSizeData<PositionListResVo> findPositionPage(PositionPageReqVo req) {
        return positionDao.findPositionPage(req);
    }

    public List<PositionListResVo> findPositionList(PositionPageReqVo req) {
        return positionDao.findPositionList(req);
    }

    public String savePosition(PositionSaveReqVo req) {
        if (StringHelper.isEmpty(req.getPositionId())) {
            req.setPositionId(StringHelper.getNewID());
            req.setCreateTime(DateHelper.getNow());
            positionDao.create(req);
        }else{
            PositionVo positionVo = positionDao.load(req.getPositionId(), PositionVo.class);
            ObjectHelper.writeWithFromClass(positionVo, req);
            positionDao.update(positionVo);
        }
        return req.getPositionId();
    }

    public void delPosition(PositionSaveReqVo req) {
            positionDao.remove(req);
    }

}
