package com.tcm.system.position.web;

import com.tcm.system.position.service.PositionService;
import com.tcm.system.position.vo.req.PositionPageReqVo;
import com.tcm.system.position.vo.req.PositionSaveReqVo;
import com.tcm.system.position.vo.res.PositionListResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/position")
public class PositionController {

    private PositionService positionService;

    public PositionController(PositionService positionService) {
        this.positionService = positionService;
    }

    @RequestMapping(value = "/findPositionPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<PositionListResVo>> findPositionPage(@RequestBody PositionPageReqVo req){
        return ResponseResult.result(positionService.findPositionPage(req));
    }

    @RequestMapping(value = "/findPositionList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<List<PositionListResVo>> findPositionList(@RequestBody PositionPageReqVo req){
        return ResponseResult.result(positionService.findPositionList(req));
    }

    @RequestMapping(value = "/savePosition", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> savePosition(@RequestBody PositionSaveReqVo req){
        positionService.savePosition(req);
        return ResponseResult.result("处理成功");
    }

    @RequestMapping(value = "/delPosition", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> delPosition(@RequestBody PositionSaveReqVo req){
        positionService.delPosition(req);
        return ResponseResult.result("处理成功");
    }
}
