package com.tcm.system.role.service.impl;

import com.pangding.web.vo.system.pd.authority.RoleAuthorityVo;
import com.tcm.system.authority.dao.TcmRoleAuthorityDao;
import com.tcm.system.authority.vo.TcmRoleAuthorityVo;
import com.tcm.system.authority.vo.req.TcmRoleAuthorityReqVo;
import com.tcm.system.role.dao.TcmRoleDao;
import com.tcm.system.role.service.TcmRoleService;
import com.tcm.system.role.vo.TcmRoleVo;
import com.tcm.system.role.vo.req.TcmRolePageReqVo;
import com.tcm.system.role.vo.req.TcmRoleSaveReqVo;
import com.tcm.system.role.vo.res.TcmRoleListResVo;
import com.tcm.system.role.vo.res.TcmRoleResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class TcmRoleServiceImpl implements TcmRoleService {

    private TcmRoleDao tcmRoleDao;
    private TcmRoleAuthorityDao tcmRoleAuthorityDao;

    public TcmRoleServiceImpl(TcmRoleDao tcmRoleDao, TcmRoleAuthorityDao tcmRoleAuthorityDao) {
        this.tcmRoleDao = tcmRoleDao;
        this.tcmRoleAuthorityDao = tcmRoleAuthorityDao;
    }

    public PageSizeData<TcmRoleListResVo> findRolePage(TcmRolePageReqVo req) {

        PageSizeData<TcmRoleListResVo>  roleVoPageSizeData = tcmRoleDao.findRolePage(req);
        return roleVoPageSizeData;
    }

    public List<TcmRoleListResVo> findRoleList(TcmRolePageReqVo req) {

        List<TcmRoleListResVo>  roleVoList = tcmRoleDao.findRoleList(req);
        return roleVoList;
    }

    public TcmRoleResVo findRoleInfo(TcmRolePageReqVo req) {
        TcmRoleResVo roleResVo = tcmRoleDao.load(req.getRoleId(), TcmRoleResVo.class);

        return roleResVo;
    }

    /**
     * 保存RoleVo对象,并保存角色权限的对应关系
     *
     * @param req
     * @return 返回角色id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String saveRole(TcmRoleSaveReqVo req) {
//        this.checkNameExist(roleVo);
        if(StringHelper.isEmpty(req.getRoleId())){
            req.setRoleId(StringHelper.getNewID());
            tcmRoleDao.create(req);
            List<String> authorityIds = req.getAuthorityIds();
            if (authorityIds != null && !authorityIds.isEmpty()) {
                for (String authorityId : authorityIds) {
                    /*查看该权限是否有上级权限*/
//                    findParent(authorityId, webRoleReqVo.getId());
                    TcmRoleAuthorityVo tcmRoleAuthorityVo = new TcmRoleAuthorityVo();
                    tcmRoleAuthorityVo.setAuthorityId(authorityId);
                    tcmRoleAuthorityVo.setRoleId(req.getRoleId());
                    tcmRoleAuthorityVo.setRoleAuthorityId(StringHelper.getNewID());
                    tcmRoleAuthorityDao.create(tcmRoleAuthorityVo);
                }
            }
        }else{
            TcmRoleVo tcmRoleVo = tcmRoleDao.load(req.getRoleId(), TcmRoleVo.class);
            ObjectHelper.writeWithFromClass(tcmRoleVo, req);
            tcmRoleDao.update(tcmRoleVo);

            TcmRoleAuthorityReqVo reqVo = new TcmRoleAuthorityReqVo();
            reqVo.setRoleId(tcmRoleVo.getRoleId());
            List<TcmRoleAuthorityVo> roleAuthorityList = tcmRoleAuthorityDao.loadList(reqVo, TcmRoleAuthorityVo.class);
            if (roleAuthorityList != null && !roleAuthorityList.isEmpty()) {
                for (TcmRoleAuthorityVo roleAuthorityRelation : roleAuthorityList) {
                    RoleAuthorityVo roleAuthorityVo = new RoleAuthorityVo();
                    roleAuthorityVo.setRoleId(roleAuthorityRelation.getRoleId());
                    roleAuthorityVo.setAuthorityId(roleAuthorityRelation.getAuthorityId());
                    tcmRoleAuthorityDao.remove(roleAuthorityVo);
                }
            }
            List<String> authorityIds = req.getAuthorityIds();
            if (authorityIds != null && !authorityIds.isEmpty()) {
                for (String authorityId : authorityIds) {
                    /*查看该权限是否有上级权限*/
//                    findParent(authorityId, webRoleReqVo.getId());
                    TcmRoleAuthorityVo tcmRoleAuthorityVo = new TcmRoleAuthorityVo();
                    tcmRoleAuthorityVo.setAuthorityId(authorityId);
                    tcmRoleAuthorityVo.setRoleId(req.getRoleId());
                    tcmRoleAuthorityVo.setRoleAuthorityId(StringHelper.getNewID());
                    tcmRoleAuthorityDao.create(tcmRoleAuthorityVo);
                }
            }

        }

        return "处理成功";
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(TcmRoleSaveReqVo req) {
        TcmRoleAuthorityReqVo reqVo = new TcmRoleAuthorityReqVo();
        reqVo.setRoleId(req.getRoleId());
        List<TcmRoleAuthorityVo> roleAuthorityList = tcmRoleAuthorityDao.loadList(reqVo, TcmRoleAuthorityVo.class);
        if (roleAuthorityList != null && !roleAuthorityList.isEmpty()) {
            for (TcmRoleAuthorityVo roleAuthorityRelation : roleAuthorityList) {
                RoleAuthorityVo roleAuthorityVo = new RoleAuthorityVo();
                roleAuthorityVo.setRoleId(roleAuthorityRelation.getRoleId());
                roleAuthorityVo.setAuthorityId(roleAuthorityRelation.getAuthorityId());
                tcmRoleAuthorityDao.remove(roleAuthorityVo);
            }
        }

        tcmRoleDao.remove(req);
    }


//    private void findParent(String authorityId, String roleId) {
//        AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
//        authorityGetReqVo.setId(authorityId);
//        AuthorityVo authorityVo = authorityDaoImpl.load(authorityGetReqVo, AuthorityVo.class);
//        if (null != authorityVo.getPid() && !authorityVo.getPid().isEmpty()) {
//            String authorityPid = authorityVo.getPid();
//            RoleAuthorityVo roleAuthorityVo = new RoleAuthorityVo();
//            roleAuthorityVo.setAuthorityId(authorityPid);
//            roleAuthorityVo.setRoleId(roleId);
//            RoleAuthorityGetReqVo roleAuthorityGetReqVo = new RoleAuthorityGetReqVo();
//            roleAuthorityGetReqVo.setRole(roleId);
//            roleAuthorityGetReqVo.setAuthority(authorityPid);
//            RoleAuthorityVo roleAuthorityVo1 = roleAuthorityDaoImpl.load(roleAuthorityGetReqVo, RoleAuthorityVo.class);
//            if (null == roleAuthorityVo1) {
//                roleAuthorityVo.setId(StringHelper.getNewID());
//                roleAuthorityDaoImpl.create(roleAuthorityVo);
//                findParent(authorityPid, roleId);
//            }
//        }
//    }

}
