package com.tcm.system.user.dao.impl;

import com.tcm.system.user.dao.TokenDao;
import com.tcm.system.user.vo.TcmLoginTokenVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

/**
 * 登录数据库写入实现类
 *
 * @author tf
 */
@Component
public class TokenDaoImpl extends BaseDaoImpl implements TokenDao {

    private static final int TOKEN_MEMORY_CACHE_TIME = 60;

    /**
     * 注册SQL语句
     */
    @Override
    protected void init() {
        // 根据实体生成增删改查语句
        register(TcmLoginTokenVo.class);

        cacheList.setClearSecond(TOKEN_MEMORY_CACHE_TIME);
    }
}
