package com.tcm.system.user.other.impl;

import com.pangding.web.constant.PangdConstant;
import com.pangding.web.vo.applet.pd.AppletVo;
import com.tcm.system.applets.dao.AppletDao;
import com.tcm.system.api.WebChatConfig;
import com.tcm.system.user.vo.req.AppletUserLoginReqVo;
import com.yanzuoguang.util.helper.HttpHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.core.codec.CodecException;
import org.springframework.stereotype.Component;

@Component
public class AppletApiService {

    private WebChatConfig webChatConfig;
    private AppletDao appletDao;

    public AppletApiService(WebChatConfig webChatConfig, AppletDao appletDao) {
        this.webChatConfig = webChatConfig;
        this.appletDao = appletDao;
    }

    public String code2Session(AppletUserLoginReqVo req) {
        String result = "";
        String url= "";
        try {
            // 微信小程序appid默认为胖丁小程序
            String appid = webChatConfig.appletsAppId;
            String secret = webChatConfig.appletsAppSecret;
            // 根据公司或者景区查询该景区的小程序参数
            if(!StringHelper.isEmpty(req.getCompanyId()) && !StringHelper.isEmpty(req.getAppid())){
                AppletVo appletReqVo = new AppletVo();
                appletReqVo.setCompanyId(req.getCompanyId());
                appletReqVo.setAppletType(PangdConstant.APPLET_WECHAT);
                appletReqVo.setAppletAppid(req.getAppid());
                AppletVo appletVo = appletDao.load(appletReqVo, AppletVo.class);
                if(!StringHelper.isEmpty(appletVo)){
                    appid = appletVo.getAppletAppid();
                    secret = appletVo.getAppletSecret();
                }
            }
            url = webChatConfig.code2Session
                    .replace("APPID", appid).replace("SECRET", secret)
                    .replace("JSCODE", req.getCode());

            result = HttpHelper.get(url);
        } catch (Exception ex) {
            throw new CodecException(ex.getMessage());
        }
        return result;
    }

}
