package com.tcm.system.user.other.impl;

import com.pangding.web.constant.PangdConstant;
import com.pangding.web.constant.UserConstant;
import com.pangding.web.util.Base64Util;
import com.pangding.web.vo.applet.pd.AppletVo;
import com.pangding.web.vo.wechat.req.WxUserReqVo;
import com.tcm.system.api.WechatApi;
import com.tcm.system.applets.dao.AppletDao;
import com.tcm.system.user.dao.UserDao;
import com.tcm.system.user.other.AppletLoginService;
import com.tcm.system.user.vo.TcmUserVo;
import com.tcm.system.user.vo.req.AppletUserLoginReqVo;
import com.tcm.system.user.vo.res.AppletsUserByCodeResVo;
import com.yanzuoguang.util.helper.JsonHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.stereotype.Service;

@Service
public class AppletLoginServiceImpl implements AppletLoginService {

    private WechatApi wechatApi;
    private UserDao userDao;

    public AppletLoginServiceImpl(WechatApi wechatApi, UserDao userDao) {
        this.wechatApi = wechatApi;
        this.userDao = userDao;
    }

    @Override
    public TcmUserVo getAppletsUserInfoByCode(AppletUserLoginReqVo req) {
        try {
            String result = wechatApi.code2Session(req);
            AppletsUserByCodeResVo appletsUserByCodeResVo = JsonHelper.deserialize(result, AppletsUserByCodeResVo.class);
            if (!StringHelper.isEmpty(appletsUserByCodeResVo.getOpenid())) {
                TcmUserVo user = userDao.load(appletsUserByCodeResVo.getOpenid(), TcmUserVo.class);
                if (StringHelper.isEmpty(user)) {
                    user = new TcmUserVo();
                    user.setUserId(StringHelper.getMD5Id(appletsUserByCodeResVo.getOpenid()));
                    user.setThirdOpenid(appletsUserByCodeResVo.getOpenid());
                    userDao.create(user);
                }
//                user.setUnionid(appletsUserByCodeResVo.getUnionid());
//                user.setNickname(Base64Util.getBASE64(appletsUserByCodeResVo.getOpenid()));
//                user.setAccountType(UserConstant.ACCOUNT_TYPE_WECHAT_APPLET);
//                user.setSourceId(req.getCompanyId());
//                user.setSourceCompanyId(req.getCompanyId());

                return user;
//                userConsumer.saveUser(user);

            } else {
                return null;
            }
        } catch (Exception e) {
            //处理异常
            e.printStackTrace();
            return null;
        }

    }


}
