package com.tcm.system.user.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.vo.BaseVo;
import com.yanzuoguang.util.vo.InitDao;
import io.swagger.annotations.ApiModelProperty;

@TableAnnotation("tcm_sys_user")
public class TcmUserVo extends BaseVo implements InitDao {

    @ApiModelProperty(notes ="用户编号")
    @TableAnnotation("user_id")
    private String userId;

    @ApiModelProperty(notes ="账户")
    private String username;

    @ApiModelProperty(notes ="密码")
    private String password;

    @ApiModelProperty(notes ="真实姓名")
    @TableAnnotation("real_name")
    private String realName;

    @ApiModelProperty(notes ="性别：0-男，1-女，2-不详")
    @TableAnnotation("user_sex")
    private Integer userSex;

    @ApiModelProperty(notes ="身份证")
    @TableAnnotation("id_card")
    private String idCard;

    @ApiModelProperty(notes ="头像")
    @TableAnnotation("head_pic")
    private String headPic;

    @ApiModelProperty(notes ="昵称")
    @TableAnnotation("nick_name")
    private String nickName;

    @ApiModelProperty(notes ="胖丁用户id")
    @TableAnnotation("pangd_user_id")
    private String pangdUserId;

    @ApiModelProperty(notes ="第三方id")
    @TableAnnotation("third_openid")
    private String thirdOpenid;

    @ApiModelProperty(notes ="角色id")
    @TableAnnotation("role_id")
    private String roleId;

    @ApiModelProperty(notes ="角色id")
    @TableAnnotation("position_id")
    private String positionId;

    @ApiModelProperty(notes ="电话")
    private String phone;

    @ApiModelProperty(notes ="备注")
    @TableAnnotation("user_remark")
    private String userRemark;

    @ApiModelProperty(notes ="状态：0-启用，1-禁用")
    @TableAnnotation("user_status")
    private Integer userStatus;

    @ApiModelProperty(notes ="审核状态：0-未审核，1-审核通过，2-审核不通过")
    @TableAnnotation("user_examine_status")
    private Integer userExamineStatus;

    @ApiModelProperty(notes ="审核不通过原因")
    @TableAnnotation("examine_message")
    private Integer examineMessage;

    @ApiModelProperty(notes ="创建时间")
    @TableAnnotation("create_time")
    private String createTime;


    @ApiModelProperty(notes ="创建时间")
    @TableAnnotation("update_time")
    private String updateTime;

    @Override
    public void init() {

    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public Integer getUserSex() {
        return userSex;
    }

    public void setUserSex(Integer userSex) {
        this.userSex = userSex;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getHeadPic() {
        return headPic;
    }

    public void setHeadPic(String headPic) {
        this.headPic = headPic;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getPangdUserId() {
        return pangdUserId;
    }

    public void setPangdUserId(String pangdUserId) {
        this.pangdUserId = pangdUserId;
    }

    public String getThirdOpenid() {
        return thirdOpenid;
    }

    public void setThirdOpenid(String thirdOpenid) {
        this.thirdOpenid = thirdOpenid;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getUserRemark() {
        return userRemark;
    }

    public void setUserRemark(String userRemark) {
        this.userRemark = userRemark;
    }

    public Integer getUserStatus() {
        return userStatus;
    }

    public void setUserStatus(Integer userStatus) {
        this.userStatus = userStatus;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getUserExamineStatus() {
        return userExamineStatus;
    }

    public void setUserExamineStatus(Integer userExamineStatus) {
        this.userExamineStatus = userExamineStatus;
    }

    public Integer getExamineMessage() {
        return examineMessage;
    }

    public void setExamineMessage(Integer examineMessage) {
        this.examineMessage = examineMessage;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }
}
