package com.tcm.system.user.vo.req;

import io.swagger.annotations.ApiModelProperty;

public class AppletUserLoginReqVo {

    @ApiModelProperty(
            notes = "微信code"
    )
    private String code;

    @ApiModelProperty(notes = "小程序的appid")
    private String appid;

    @ApiModelProperty(
            notes = "请求id"
    )
    private String reqId;

    @ApiModelProperty(
            notes = "公司ID"
    )
    private String companyId;


    @ApiModelProperty(
            notes = "授权类型" +
                    "支付宝：" +
                    "     * auth_base(静默授权)：静默授权，用户无需点击确认授权，默认返回 auth_code。" +
                    "     * auth_user(主动授权)：首次授权需要用户手动点击同意，用户同意后，返回 auth_code；商家需要考虑用户拒绝授权的情况并进行相应容错。" +
                    "     * 如果授权关系依旧存在，下次进入页面时也会静默授权" +
                    "     * 微信：snsapi_base （不弹出授权页面，直接跳转，只能获取用户openid），" +
                    "     *      snsapi_userinfo （弹出授权页面，可通过openid拿到昵称、性别、所在地。并且， 即使在未关注的情况下，只要用户授权，也能获取其信息 ）"
    )
    private String scopes;

    /**
     * 来源 1微信 2支付宝
     */
    @ApiModelProperty(
            notes = "返回状态码"
    )
    private Integer source;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getReqId() {
        return reqId;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getScopes() {
        return scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }
}
