package com.tcm.system.user.web;

import com.tcm.system.user.other.AppletLoginService;
import com.tcm.system.user.service.LoginService;
import com.tcm.system.user.vo.TcmUserVo;
import com.tcm.system.user.vo.req.AppletUserLoginReqVo;
import com.tcm.system.user.vo.req.UserLoginReqVo;
import com.tcm.system.user.vo.res.UserLoginResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value="login")
@Api(value = "用户登录类")
public class LoginController {

    private LoginService loginService;
    private AppletLoginService AppletLoginService;

    public LoginController(LoginService loginService, com.tcm.system.user.other.AppletLoginService appletLoginService) {
        this.loginService = loginService;
        AppletLoginService = appletLoginService;
    }

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param req
     * @return
     */
    @ApiOperation(value ="登录", notes = "返回登录信息")
    @RequestMapping(value = "/login", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<UserLoginResVo> webLogin(@RequestBody UserLoginReqVo req){
        CheckerHelper.newInstance()
                .notBlankCheck("account or phone", req.getAccountOrPhone())
                .notBlankCheck("password", req.getPassword())
//                .notBlankCheck("loginType", req.getLoginType())
                .checkException();
        return ResponseResult.result(loginService.login(req));
    }

    @ApiOperation(value ="登录", notes = "返回登录信息")
    @RequestMapping(value = "/appletLogin", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<TcmUserVo> appletLogin(@RequestBody AppletUserLoginReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("code", req.getCode())
                .notBlankCheck("source", req.getSource())
                .checkException(req);
        return ResponseResult.result(AppletLoginService.getAppletsUserInfoByCode(req));
    }

}
