package com.tcm.system.user.web;

import com.tcm.system.user.service.TokenService;
import com.tcm.system.user.vo.TcmLoginTokenVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 日志操作控制类
 *
 * @author tf
 */
@RestController
@RequestMapping("/token")
public class TokenController {

    @Autowired
    private TokenService tokenService;


    /**
     * 登录实体创建
     *
     * @param loginVo
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> save(@RequestBody TcmLoginTokenVo loginVo) {
        CheckerHelper.newInstance()
                .notBlankCheck("token", loginVo.getToken())
                .notBlankCheck("data", loginVo.getData())
                .notBlankCheck("expairTime", loginVo.getExpairTime())
                .checkDate("expairTime", loginVo.getExpairTime())
                .checkException(loginVo);

        return ResponseResult.result(tokenService.save(loginVo));
    }

    /**
     * 加载登录信息
     *
     * @param loginVo 登录信息
     */
    @RequestMapping(value = "/load", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<TcmLoginTokenVo> load(@RequestBody TcmLoginTokenVo loginVo) {
        CheckerHelper.newInstance()
                .notBlankCheck("token", loginVo.getToken())
                .checkException(loginVo);

        return ResponseResult.result(tokenService.load(loginVo));
    }

    /**
     * 加载登录信息
     *
     * @param loginVo 登录信息
     */
    @RequestMapping(value = "/remove", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<Integer> remove(@RequestBody TcmLoginTokenVo loginVo) {
        CheckerHelper.newInstance()
                .notBlankCheck("token", loginVo.getToken())
                .checkException(loginVo);

        return ResponseResult.result(tokenService.remove(loginVo));
    }
}
