package com.pangding.web.authority.controller;


import com.pangding.web.authority.currency.Result;
import com.pangding.web.authority.dto.UserDto;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping(value = "/user")
public class UserController {

    @Autowired
    UserService userServiceImpl;

    /**
     * 新增用户
     * @param userDto
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveUser(@RequestBody UserDto userDto){

        userServiceImpl.checkAccount(userDto);
        String saltPassword = userServiceImpl.passwordEncoder(userDto.getPassword());
        userDto.setPassword(saltPassword);
        userDto.setId(UUID.randomUUID().toString().replace("-",""));
        userServiceImpl.saveUser(userDto);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 修改用户信息
     * @param //userDto
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object updateUser(@RequestBody UserDto userDto){
        userServiceImpl.checkAccount(userDto);
        userDto.setPassword(userServiceImpl.passwordEncoder(userDto.getPassword()));
        userServiceImpl.updateUser(userDto);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 查询用户列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object listUsers(){

        List<UserVo> userVoList = userServiceImpl.listUserVo();
        List<UserDto> userDtoList = new ArrayList(userVoList.size());

        for (int index1 = 0;index1 < userVoList.size();index1++){
            UserVo userVo = userVoList.get(index1);
            GetUserRoleListByUserIdReqVo reqVo = new GetUserRoleListByUserIdReqVo();
            reqVo.setUserId(userVo.getId());
            List<UserRoleRelation> userRole = userServiceImpl.listUserRoleListByUserId(reqVo);
            List<String> roleIdList = new ArrayList(userRole.size());
            for (UserRoleRelation userRoleRelation:userRole) {
                roleIdList.add(userRoleRelation.getRoleId());
            }
            List<String> roleNameList = new ArrayList(roleIdList.size());
            for (int index2 = 0;index2 < roleIdList.size();index2++){
                GetRoleByRoleIdReqVo getRoleByRoleIdReqVo = new GetRoleByRoleIdReqVo();
                getRoleByRoleIdReqVo.setId(roleIdList.get(index2));
                RoleVo role = userServiceImpl.getRoleByRoleId(getRoleByRoleIdReqVo);
                roleNameList.add(role.getName());
            }
            UserDto userDto = userServiceImpl.makeUserDto(userVo,roleIdList,roleNameList);
            userDtoList.add(userDto);
        }

        Result result = new Result(0,"SUCCESS",userDtoList);
        return result;
    }

    /**
     * 根据ID查询用户
     * @param //id
     * @return
     */
    @RequestMapping(value = "/user/{userId}", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object user(@PathVariable String userId){

        UserVo userVo = userServiceImpl.getUserById(userId);
        if(userVo == null){
            return new Result(4001,"该用户不存在",null);
        }
        GetUserRoleListByUserIdReqVo reqVo = new GetUserRoleListByUserIdReqVo();
        reqVo.setUserId(userVo.getId());
        List<UserRoleRelation> userRole = userServiceImpl.listUserRoleListByUserId(reqVo);
        List<String> roleIdList = new ArrayList(userRole.size());
        for (UserRoleRelation userRoleRelation:userRole) {
            roleIdList.add(userRoleRelation.getRoleId());
        }
        List<String> roleNameList = new ArrayList(roleIdList.size());
        for (int index2 = 0;index2 < roleIdList.size();index2++){
            GetRoleByRoleIdReqVo getRoleByRoleIdReqVo = new GetRoleByRoleIdReqVo();
            getRoleByRoleIdReqVo.setId(roleIdList.get(index2));
            RoleVo role = userServiceImpl.getRoleByRoleId(getRoleByRoleIdReqVo);
            roleNameList.add(role.getName());
        }
        UserDto userDto = userServiceImpl.makeUserDto(userVo,roleIdList,roleNameList);
        return new Result(0,"SUCCESS",userDto);
    }

}
