package com.pangding.web.authority.dao;

import com.pangding.web.authority.vo.GetAuthorityByIdReqVo;
import com.pangding.web.authority.vo.ListLevel1ReqVo;
import com.pangding.web.authority.vo.AuthorityVo;
import com.yanzuoguang.dao.BaseDao;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface AuthorityDao extends BaseDao {

    /**
     * 检查新建或修改的authorityVo对象是否合法
     *
     * @param authorityVo authorityVo对象
     */
    void checkValid(AuthorityVo authorityVo);

    /**
     * 根据主键获取authorityVo对象
     *
     * @param getAuthorityByIdReqVo 主键
     * @return authorityVo对象
     */
    AuthorityVo getAuthorityById(GetAuthorityByIdReqVo getAuthorityByIdReqVo);

    /**
     * 获取authorityVo对象列表
     *
     * @return authorityVo对象列表
     */
    List<AuthorityVo> listAll();


    /**
     * 获取一级权限对象列表
     *
     * @param listLevel1ReqVo ListLevel1ReqVo对象，仅用于拼接sql语句查询条件，无实际意义
     * @return 权限对象列表
     */
    List<AuthorityVo> listLevel1(ListLevel1ReqVo listLevel1ReqVo);
}
