package com.pangding.web.authority.dao;

import com.pangding.web.authority.vo.GetRoleAuthorityListByRoleIdReqVo;
import com.pangding.web.authority.vo.GetRoleAuthorityListByAuthorityIdReqVo;
import com.pangding.web.authority.vo.RoleAuthorityRelation;
import com.yanzuoguang.dao.BaseDao;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface RoleAuthorityDao extends BaseDao {
    /**
     * 通过角色id获取角色权限关系表对象列表
     *
     * @param getRoleAuthorityListByRoleIdReqVo 角色id
     * @return 角色权限关系表主键列表
     */
    List<RoleAuthorityRelation> getRoleAuthorityListByRoleId(GetRoleAuthorityListByRoleIdReqVo getRoleAuthorityListByRoleIdReqVo);

    /**
     * 通过权限id获取角色权限关系表主键列表
     *
     * @param getRoleAuthorityListByAuthorityIdReqVo 封装权限id
     * @return 角色权限关系表主键列表
     */
    List<RoleAuthorityRelation> getRoleAuthorityListByAuthorityId(GetRoleAuthorityListByAuthorityIdReqVo getRoleAuthorityListByAuthorityIdReqVo);
}
