package com.pangding.web.authority.dao;

import com.pangding.web.authority.vo.GetUserByAccountReqVo;
import com.pangding.web.authority.vo.GetUserByIdReqVo;
import com.pangding.web.authority.vo.UserVo;
import com.yanzuoguang.dao.BaseDao;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface UserDao extends BaseDao {


    /**
     * 通过账户名获取相同的UserVo对象
     *
     * @param account 账户名
     * @return UserVo对象
     */
    void checkAccount(UserVo account);

    /**
     * 获取UserVo对象列表
     *
     * @return UserVo对象列表
     */
    List<UserVo> listUserVo();

    /**
     * 通过用户id查询UserVo对象
     *
     * @param id 用户id
     * @return UserVo对象
     */
    UserVo getUserById(GetUserByIdReqVo id);
}
