package com.pangding.web.authority.dao;

import com.pangding.web.authority.vo.GetUserRoleListByRoleIdReqVo;
import com.pangding.web.authority.vo.GetUserRoleListByUserIdReqVo;
import com.pangding.web.authority.vo.UserRoleRelation;
import com.yanzuoguang.dao.BaseDao;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface UserRoleDao extends BaseDao {

    /**
     * 通过userId查询用户角色对应关系列表
     *
     * @param userId 用户id
     * @return user和role对应关系对象列表
     */
    List<UserRoleRelation> getUserRoleListByUserId(GetUserRoleListByUserIdReqVo userId);

    /**
     * 通过角色id获取用户和角色的对应关系对象列表
     *
     * @param roleId 封装角色id
     * @return 用户和角色的对应关系对象列表
     */
    List<UserRoleRelation> getUserRoleListByRoleId(GetUserRoleListByRoleIdReqVo roleId);
}
