package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.AuthorityDao;
import com.pangding.web.authority.vo.GetAuthorityByIdReqVo;
import com.pangding.web.authority.vo.ListLevel1ReqVo;
import com.pangding.web.authority.vo.AuthorityVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;
/**
 * @author zhangjinyao
 */
@Component
public class AuthorityDaoImpl extends BaseDaoImpl implements AuthorityDao {

    private static final String CHECK_VALID = "CHECK_VALID";
    private static final String SELECT = "SELECT";

    @Override
    protected void init() {
        register(AuthorityVo.class);

        table.addExist(CHECK_VALID,"name","url");

        table.add(SELECT,"select * from pd_authority where 1=1")
                .add("exist","and pid = '' ")
                .add("id","and pid = ?");
    }

    @Override
    public void checkValid(AuthorityVo authorityVo) {
        this.checkExist(CHECK_VALID,authorityVo,"该权限不合法，请修改权限名或权限url");
    }

    @Override
    public AuthorityVo getAuthorityById(GetAuthorityByIdReqVo getAuthorityByIdReqVo) {
        return this.load(getAuthorityByIdReqVo, AuthorityVo.class);
    }

    @Override
    public List<AuthorityVo> listAll() {

        return this.query(AuthorityVo.class,SELECT,null);
    }

    @Override
    public List<AuthorityVo> listLevel1(ListLevel1ReqVo listLevel1ReqVo) {
        return this.query(AuthorityVo.class,SELECT,listLevel1ReqVo);
    }

}
