package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.UserDao;
import com.pangding.web.authority.vo.GetUserByAccountReqVo;
import com.pangding.web.authority.vo.GetUserByIdReqVo;
import com.pangding.web.authority.vo.UserVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class UserDaoImpl extends BaseDaoImpl implements UserDao {


    private static final String SELECT = "SELECT";
    private static final String CHECK_ACCOUNT = "CHECK_ACCOUNT";

    @Override
    protected void init() {
        register(UserVo.class);

        table.add(SELECT,"select * from pd_user where 1=1");

        table.addExist(CHECK_ACCOUNT,"account");

    }

    @Override
    public void checkAccount(UserVo account) {
        this.checkExist(CHECK_ACCOUNT,account,"用戶名已存在");
    }


    @Override
    public List<UserVo> listUserVo() {

        return this.query(UserVo.class,SELECT,null);

    }

    @Override
    public UserVo getUserById(GetUserByIdReqVo id) {
        return this.load(id,UserVo.class);
    }
}
