package com.pangding.web.authority.service;

import com.pangding.web.authority.vo.AuthorityVo;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface AuthorityService {
    /**
     * 保存authorityVo对象数据
     *
     * @param authorityVo authorityVo对象
     */
    void save(AuthorityVo authorityVo);

    /**
     * 更新authorityVo对象数据
     *
     * @param authorityVo authorityVo对象
     */
    void update(AuthorityVo authorityVo);

    /**
     * 通过权限表主键获取authorityVo对象
     *
     * @param id 主键
     * @return authorityVo对象
     */
    AuthorityVo getAuthorityById(String id);

    /**
     * 通过权限表主键删除authorityVo对象，并删除权限和角色的对应关系
     *
     * @param id 主键
     */
    void deleteAuthorityById(String id);

    /**
     * 检查新建、修改的authorityVo对象是否合法
     *
     * @param authorityVo authorityVo对象
     * @return 0：合法 else：不合法
     */
    void checkValid(AuthorityVo authorityVo);

    /**
     * 获取authorityVo对象列表
     *
     * @return authorityVo对象列表
     */
    List<AuthorityVo> listAllAuthority();

    /**
     * 获取一级权限列表
     *
     * @return 一级权限列表
     */
    List<AuthorityVo> listLevel1();

}
