package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.RoleAuthorityDao;
import com.pangding.web.authority.dao.AuthorityDao;
import com.pangding.web.authority.service.AuthorityService;
import com.pangding.web.authority.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.UUID;

/**
 * @author zhangjinyao
 */
@Service
public class AuthorityServiceImpl implements AuthorityService {

    @Autowired
    AuthorityDao authorityDao;

    @Autowired
    RoleAuthorityDao roleAuthorityDao;

    @Override
    public void save(AuthorityVo authorityVo) {
        authorityVo.setId(UUID.randomUUID().toString().replace("-",""));
        authorityDao.create(authorityVo);
    }

    @Override
    public void update(AuthorityVo authorityVo) {
        authorityDao.update(authorityVo);
    }

    @Override
    public void checkValid(AuthorityVo authorityVo) {
        authorityDao.checkValid(authorityVo);
    }

    @Override
    public AuthorityVo getAuthorityById(String id) {
        GetAuthorityByIdReqVo getAuthorityByIdReqVo = new GetAuthorityByIdReqVo();
        getAuthorityByIdReqVo.setId(id);
        AuthorityVo authorityVo = authorityDao.getAuthorityById(getAuthorityByIdReqVo);
        return authorityVo != null ? authorityVo : null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteAuthorityById(String id) {
        AuthorityVo authorityVo = new AuthorityVo();
        authorityVo.setId(id);
        authorityDao.remove(authorityVo);
        GetRoleAuthorityListByAuthorityIdReqVo getRoleAuthorityListByAuthorityIdReqVo = new GetRoleAuthorityListByAuthorityIdReqVo();
        getRoleAuthorityListByAuthorityIdReqVo.setAuthorityId(id);
        List<RoleAuthorityRelation> roleAuthorityList = roleAuthorityDao.getRoleAuthorityListByAuthorityId(getRoleAuthorityListByAuthorityIdReqVo);
        for (RoleAuthorityRelation roleAuthority:roleAuthorityList) {
            roleAuthorityDao.remove(roleAuthority);
        }
    }

    @Override
    public List<AuthorityVo> listAllAuthority() {
        List<AuthorityVo> list = authorityDao.listAll();
        return (list != null && list.size() != 0) ? list : null;
    }

    @Override
    public List<AuthorityVo> listLevel1() {
        ListLevel1ReqVo listLevel1ReqVo = new ListLevel1ReqVo();
        listLevel1ReqVo.setExist("exist");
        List<AuthorityVo> list = authorityDao.listLevel1(listLevel1ReqVo);
        return (list != null && list.size() != 0) ? list : null;
    }
}
