package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyMsgDao;
import com.pangding.web.authority.dao.DeviceDao;
import com.pangding.web.authority.dao.UserDao;
import com.pangding.web.authority.mq.CompanyConsumer;
import com.pangding.web.authority.service.CompanyMsgService;
import com.pangding.web.constant.CompanyConstant;
import com.pangding.web.partner.mq.PartnerProcedure;
import com.pangding.web.partner.vo.req.SoundContentVo;
import com.pangding.web.vo.order.tl.SoundContentInfoVo;
import com.pangding.web.vo.order.tl.SoundContentReqVo;
import com.pangding.web.vo.order.tl.SoundReqVo;
import com.pangding.web.vo.system.req.CompanyMsgReqVo;
import com.pangding.web.vo.system.req.DeviceReqVo;
import com.pangding.web.vo.system.res.CompanyMsgResVo;
import com.pangding.web.vo.system.res.DeviceResVo;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class CompanyMsgServiceImpl implements CompanyMsgService {

    @Autowired
    private CompanyMsgDao companyMsgDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private PartnerProcedure partnerProcedure;
    @Autowired
    private CompanyConsumer companyConsumer;


    @Override
    public PageSizeData<CompanyMsgResVo> findCompanyMsgList(CompanyMsgReqVo req) {
        return companyMsgDao.findPageCompanyMsgList(req);
    }

    @Override
    public ResponseResult saveCompanyMsg(CompanyMsgReqVo reqVo) {

        companyMsgDao.create(reqVo);

        SoundContentVo soundContentVo = new SoundContentVo();
        soundContentVo.setTipContent(reqVo.getMsgContent());
        soundContentVo.setTipSound(reqVo.getMsgSound());
        soundContentVo.setTipUrl("http://frapp.pangdly.com?msg=" + soundContentVo.getTipContent());

//        UserReqVo userReqVo = new UserReqVo();
//        userReqVo.setCompanyId(reqVo.getCompanyId());
//        List<UserResVo> userResList = userDao.loadList(userReqVo, UserResVo.class);
//        for (int i = 0; i < userResList.size(); i++) {
//            if (1 == userResList.get(i).getReceiveFlag()) {
//                partnerProcedure.sendSoundContent(userResList.get(i).getId(), soundContentVo);
//            }
//        }

        DeviceReqVo deviceReqVo = new DeviceReqVo();
        deviceReqVo.setCompanyId(reqVo.getCompanyId());
        deviceReqVo.setDeviceType(CompanyConstant.DEVICE_SOUND);
        DeviceResVo deviceResVo = deviceDao.load(deviceReqVo, DeviceResVo.class);
        if (!StringHelper.isEmpty(deviceResVo)) {
            String deviceCode = deviceResVo.getDeviceCode();
            String deviceName = deviceResVo.getDeviceName();
            SoundContentInfoVo soundContentInfoVo = new SoundContentInfoVo();
            soundContentInfoVo.setMsg_content(reqVo.getMsgContent());
            soundContentInfoVo.setMsg_id(reqVo.getId());
            soundContentInfoVo.setVoice_speed("50");
            SoundContentReqVo soundContentReqVo = new SoundContentReqVo();
            soundContentReqVo.setInfo(soundContentInfoVo);
            soundContentReqVo.setType("audio");

            SoundReqVo soundReqVo = new SoundReqVo();
            soundReqVo.setContent(soundContentReqVo);
            soundReqVo.setProKey(deviceCode);
            soundReqVo.setTopicName("/" + deviceCode + "/" + deviceName + "/user/report");
            companyConsumer.sendSound(soundReqVo);
        }
        return ResponseResult.result("处理成功");
    }

}
