package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.DeviceDao;
import com.pangding.web.vo.system.pd.device.DeviceVo;
import com.pangding.web.vo.system.req.DeviceReqVo;
import com.pangding.web.vo.system.res.DeviceResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

/**
 * @author tangfang
 * @date 2020-08-19
 */
@Component
public class DeviceDaoImpl extends BaseDaoImpl implements DeviceDao {

    private static final String QUERY_LIST = "QUERY_LIST";

    private static final String QUERY_INFO = "QUERY_INFO";

    @Override
    protected void init() {
        register(DeviceVo.class);

        table.add(QUERY_LIST, "SELECT * FROM pd_device WHERE 1=1 {WHERE}")
                .add("deviceId", " AND device_id = ? ")
                .add("deviceCode", "AND device_code = ? ")
                .add("deviceName", " AND device_name = ? ")
                .add("deviceType", " AND device_type = ? ")
                .add("companyId", " AND company_id = ? ")
                .add("channelId", " AND channel_id = ? ")
                .add("merchantId", " AND merchant_id = ? ")
                .add("deviceStatus", " AND device_status = ? ");

        table.add(QUERY_INFO, "SELECT a.*,b.company_name FROM pd_device a LEFT JOIN pd_company b ON a.company_id = b.id WHERE 1=1 {WHERE")
                .add("deviceId", " AND device_id = ? ")
                .add("deviceCode", " AND device_code = ? ")
                .add("deviceName", " AND device_name = ? ")
                .add("deviceType", " AND device_type = ? ")
                .add("companyId", " AND company_id = ? ")
                .add("channelId", " AND channel_id = ? ")
                .add("merchantId", " AND merchant_id = ? ")
                .add("deviceStatus", " AND device_status = ? ");
        ;

    }

    @Override
    public PageSizeData<DeviceResVo> findDevicePage(DeviceReqVo req) {
        return queryPage(DeviceResVo.class, req, QUERY_LIST, req);
    }

    @Override
    public DeviceResVo findDeviceInfo(DeviceReqVo req) {
        return queryFirst(DeviceResVo.class,  QUERY_INFO, req);
    }

}
