package com.pangding.web.authority.mq;

import com.pangding.web.mq.CompanyProducer;
import com.pangding.web.mq.PayProducer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 消息队列初始化服务，用于重启时，初始化消息队列对象
 *
 * @author 11488
 */
@Component
public class MqPlan implements InitializingBean {

    @Autowired
    private CompanyProducer companyProducer;
    @Autowired
    private PayProducer payProducer;


    @Override
    public void afterPropertiesSet() throws Exception {
        companyProducer.init();
        payProducer.init();
    }
}
