package com.pangding.web.authority.util;

import com.pangding.web.authority.dao.CompanyBankCardDao;
import com.pangding.web.authority.dao.CompanyDao;
import com.pangding.web.authority.dao.CompanyExtendDao;
import com.pangding.web.authority.service.FinanceService;
import com.pangding.web.vo.order.req.CapitalFlowReqVo;
import com.pangding.web.vo.system.pd.company.CompanyBankCardVo;
import com.pangding.web.vo.system.req.company.CompanyBankCardReqVo;
import com.pangding.web.vo.system.req.company.CompanyReqVo;
import com.pangding.web.vo.system.req.company.UpdateCompanyMoneyReqVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 订单相关的定时任务
 */
@Component
@Configuration
@EnableScheduling
public class UserTask {

    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CompanyExtendDao companyExtendDao;
    @Autowired
    private CompanyBankCardDao companyBankCardDao;
    @Autowired
    private FinanceService financeService;

    /**
     * 自动提现
     */
//    @Scheduled(cron = "0 0 10 * * ?")
    public void automaticWithdrawal() {
        CompanyReqVo companyReqVo = new CompanyReqVo();
        companyReqVo.setWithdrawRule(0);
        companyReqVo.setExamineStatus(1);
        companyReqVo.setStatus(6);
        List<CompanyResVo> companyResVoList = companyDao.findCompanyList(companyReqVo);
        for (int i = 0; i < companyResVoList.size(); i++) {
            CompanyResVo companyResVo = companyResVoList.get(i);
            CompanyBankCardReqVo companyBankCardReqVo = new CompanyBankCardReqVo();
            companyBankCardReqVo.setCompanyId(companyResVo.getId());
            companyBankCardReqVo.setStatus(1);
            companyBankCardReqVo.setIsDefault(1);
            CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(companyBankCardReqVo, CompanyBankCardVo.class);
            if (StringHelper.isEmpty(companyBankCardReqVo)) {
                // 该公司没有默认银行卡 不可提现。
                continue;
            }
            CapitalFlowReqVo capitalFlowReqVo = new CapitalFlowReqVo();
            capitalFlowReqVo.setCompanyId(companyResVo.getId());
            capitalFlowReqVo.setOrderMoney(companyResVo.getWithdrawTotalCash());
            capitalFlowReqVo.setOrderId(companyResVo.getId());
            capitalFlowReqVo.setStatus(0);
            capitalFlowReqVo.setBankCardCode(companyBankCardVo.getBankCardCode());
            capitalFlowReqVo.setBankId(companyBankCardVo.getId());
            capitalFlowReqVo.setCategory(1);
            capitalFlowReqVo.setOrderFee(0d);
            capitalFlowReqVo.setTime(DateHelper.getNow());
            capitalFlowReqVo.setRemark(companyResVo.getCompanyName() + "自动提现：" + DateHelper.getNow());
            financeService.applyWithdrawal(capitalFlowReqVo);
        }
    }

    /**
     * 服务费
     */
    @Scheduled(cron = "0 5 0 * * ?")
    public void serviceCharge() {
        CompanyReqVo companyReqVo = new CompanyReqVo();
        companyReqVo.setServiceChargeStatus(1);
        companyReqVo.setExamineStatus(1);
        companyReqVo.setStatus(6);
        List<CompanyResVo> companyResVoList = companyDao.findCompanyList(companyReqVo);
        for (int i = 0; i < companyResVoList.size(); i++) {
            CompanyResVo companyResVo = companyResVoList.get(i);
            double serviceCharge = financeService.getServiceCharge(companyResVo);
            if(serviceCharge > 0 ){
                UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
                updateCompanyMoneyReqVo.setCompanyId(companyResVo.getId());
                updateCompanyMoneyReqVo.setNewWithdrawTotalCash(0d);
                updateCompanyMoneyReqVo.setLateFee(-serviceCharge);
                companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);
            }
        }
    }

}
