package com.pangding.web.authority.controller;


import com.pangding.web.authority.service.CompanyAgreementService;
import com.pangding.web.authority.service.CompanyMoneyService;
import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.vo.system.req.company.CompanyAgreementReqVo;
import com.pangding.web.vo.system.req.company.CompanyMoneyReqVo;
import com.pangding.web.vo.system.req.company.CompanyReqVo;
import com.pangding.web.vo.system.req.company.SaveCompanyReqVo;
import com.pangding.web.vo.system.res.company.CompanyMoneyTotalResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/newCompany", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class CompanyController {

    @Autowired
    private CompanyService companyService;
    @Autowired
    private CompanyAgreementService companyAgreementService;


    /**
     * 找到公司余额
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "/findCompanyBalance", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult findCompanyBalance(@RequestBody CompanyReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("id", req.getId()).checkException();
        return ResponseResult.result(companyService.findCompanyBalance(req));
    }

    @RequestMapping(value = "/updateCompanyInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "公司，个人实名制", notes = "返回实名制结果")
    public ResponseResult<SaveCompanyReqVo> updateCompanyInfo(@RequestBody SaveCompanyReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("id", req.getCompanyVo().getId()).checkException();
        return companyService.updateCompanyInfo(req);
    }

    @RequestMapping(value = "/checkAgreement")
    @ApiOperation(value = "查询公司是否已签署某合同", notes = "返回合同信息")
    public ResponseResult checkAgreement(@RequestBody CompanyAgreementReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("companyId", req.getCompanyId())
                .notBlankCheck("agreementCode", req.getAgreementCode())
                .checkException();
        return ResponseResult.resultAllowNull(companyAgreementService.checkAgreement(req));
    }

    @RequestMapping(value = "saveComapnyAgreement")
    @ApiOperation(value = "公司签署合同", notes = "返回签署结果")
    public ResponseResult saveCompanyAgreement(@RequestBody CompanyAgreementReqVo req){
        CheckerHelper.newInstance().notBlankCheck("companyId", req.getCompanyId())
                .notBlankCheck("agreementId", req.getAgreementId())
                .notBlankCheck("agreementCode", req.getAgreementCode())
                .checkException();
        return ResponseResult.result(companyAgreementService.saveCompanyAgreement(req));

    }

    @RequestMapping(value = "findCompanyById")
    @ApiOperation(value = "找到公司信息", notes = "找到公司信息")
    public ResponseResult findCompanyById(@RequestBody CompanyReqVo req){
        CheckerHelper.newInstance().notBlankCheck("", req.getId()).checkException();
        return ResponseResult.result(companyService.findCompanyById(req));
    }



}
