package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.TokenService;
import com.pangding.web.vo.system.pd.LoginTokenVo;
import com.pangding.web.vo.system.req.LoginReqVo;
import com.pangding.web.vo.system.req.company.CompanyKeyReqVo;
import com.pangding.web.vo.system.res.company.CompanyKeyResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 日志操作控制类
 *
 * @author 颜佐光
 */
@RestController
@RequestMapping("/token")
public class TokenController {

    @Autowired
    private TokenService tokenService;


    /**
     * 获取分销商key
     */
    @RequestMapping(value = "/getCompanyKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<CompanyKeyResVo> getCompanyKey(@RequestBody CompanyKeyReqVo companyKeyReqVo) {
        CheckerHelper.newInstance()
                .notBlankCheck("companyId", companyKeyReqVo.getCompanyId())
                .checkException(companyKeyReqVo);

        return ResponseResult.result(tokenService.getCompanyKey(companyKeyReqVo));
    }

    /**
     * 登录实体创建
     *
     * @param loginVo
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> save(@RequestBody LoginReqVo loginVo) {
        CheckerHelper.newInstance()
                .notBlankCheck("token", loginVo.getToken())
                .notBlankCheck("data", loginVo.getData())
                .notBlankCheck("expairTime", loginVo.getExpairTime())
                .checkDate("expairTime", loginVo.getExpairTime())
                .checkException(loginVo);

        return ResponseResult.result(tokenService.save(loginVo));
    }

    /**
     * 加载登录信息
     *
     * @param loginVo 登录信息
     */
    @RequestMapping(value = "/load", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<LoginTokenVo> load(@RequestBody LoginReqVo loginVo) {
        CheckerHelper.newInstance()
                .notBlankCheck("token", loginVo.getToken())
                .checkException(loginVo);

        return ResponseResult.result(tokenService.load(loginVo));
    }

    /**
     * 加载登录信息
     *
     * @param loginVo 登录信息
     */
    @RequestMapping(value = "/remove", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<Integer> remove(@RequestBody LoginReqVo loginVo) {
        CheckerHelper.newInstance()
                .notBlankCheck("token", loginVo.getToken())
                .checkException(loginVo);

        return ResponseResult.result(tokenService.remove(loginVo));
    }
}
