package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyExtendDao;
import com.pangding.web.authority.dao.WechatUserDao;
import com.pangding.web.authority.service.IndexService;
import com.pangding.web.authority.util.TimeConstant;
import com.pangding.web.authority.vo.CompanyExtendVo;
import com.pangding.web.authority.vo.WechatUserVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.*;

/**
 * @Author zhangjinyao
 * @create 2019/5/27 11:19
 */
@Service
public class IndexServiceImpl implements IndexService {
    @Autowired
    CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    WechatUserDao wechatUserDaoImpl;

    /**
     * 通过公司id获取该公司的可提现余额
     * @param reqVo 封装了公司id的请求对象
     * @return 可提现的金额
     */
    @Override
    public BigDecimal getWithdrawCash(WithdrawCashReqVo reqVo) {
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(reqVo,CompanyExtendVo.class);
        if (null == companyExtendVo){
            throw new CodeException("未查到该公司数据");
        }
        BigDecimal cash = companyExtendVo.getWithdrawTotalCash();
        if (null == cash){
            throw new CodeException("暂无可提现余额信息");
        }
        return cash;
    }

    /**
     * 通过公司id获取该公司累积总收益
     * @param reqVo 封装了公司id的请求对象
     * @return 累计总收益
     */
    @Override
    public BigDecimal getTotalIncome(TotalIncomeReqVo reqVo) {
        /*此处需调用订单服务传入公司id获取累积总收益
        * 目前仅返回null*/
        return null;
    }

    /**
     * 通过公司id获取该公司的用户沉淀量
     * @param reqVo 封装了公司id的请求对象
     * @return  用户沉淀量
     */
    @Override
    public Integer getUserPrecipitation(UserPrecipitationReqVo reqVo) {
        WechatUserGetReqVo getReqVo = new WechatUserGetReqVo();
        getReqVo.setCompanyId(reqVo.getId());
        List<WechatUserVo> wechatUserVoList = wechatUserDaoImpl.loadList(getReqVo, WechatUserVo.class);
        if (null == wechatUserVoList || wechatUserVoList.isEmpty()){
            return 0;
        }
        return wechatUserVoList.size();
    }

    /**
     * 通过公司id获取该公司今日实收金额
     * @param reqVo 封装了公司id的请求对象
     * @return  今日实收金额
     */
    @Override
    public BigDecimal getTodayIncome(TodayIncomeReqVo reqVo) {
        /*此处需调用订单服务传入公司id获取今日实收金额
         * 目前仅返回null*/
        return null;
    }

    /**
     * 通过公司id获取该公司的跨界盈利
     * @param reqVo 封装了公司id的请求对象
     * @return  跨界盈利
     */
    @Override
    public BigDecimal getTransboundaryProfit(TransboundaryProfitReqVo reqVo) {
        /*此处需调用订单服务传入公司id获取跨界盈利
         * 目前仅返回null*/
        return null;
    }

    /**
     * 通过公司id获取该公司的用户趋势
     * @param reqVo 封装了公司id的请求对象
     * @return  用户趋势
     */
    @Override
    public List<Long> getUserTrending(UserTrendingReqVo reqVo) {
        List<Long> resList = new ArrayList();
        String[] monthList = {TimeConstant.JANUARY_BEGIN
                ,TimeConstant.FEBRUARY_BEGIN
                ,TimeConstant.MARCH_BEGIN
                ,TimeConstant.APRIL_BEGIN
                ,TimeConstant.MAY_BEGIN
                ,TimeConstant.JUNE_BEGIN
                ,TimeConstant.JULY_BEGIN
                ,TimeConstant.AUGUST_BEGIN
                ,TimeConstant.SEPTEMBER_BEGIN
                ,TimeConstant.OCTOBER_BEGIN
                ,TimeConstant.NOVEMBER_BEGIN
                ,TimeConstant.DECEMBER_BEGIN
                ,TimeConstant.YEAR_END};
        WechatUserGetReqVo getReqVo = new WechatUserGetReqVo();
        getReqVo.setCompanyId(reqVo.getId());
        for (int i = 0; i < monthList.length-1; i++) {
            getReqVo.setStart(monthList[i]);
            getReqVo.setEnd(monthList[i+1]);
            List<Map> list = (List<Map>) wechatUserDaoImpl.getUserNum(getReqVo);
            Long num = (Long) list.get(0).get("num");
            resList.add(num);
        }
        return resList;
    }

    /**
     * 通过公司id获取该公司的资金趋势
     * @param reqVo 封装了公司id的请求对象
     * @return  资金趋势
     */
    @Override
    public Object getFundTrending(FundTrendingReqVo reqVo) {
        /*调用订单服务获取资金趋势
        * 目前仅返回null*/
        return null;
    }
}
