package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.FinanceService;
import com.pangding.web.authority.vo.reqvo.WithdrawalReqVo;
import com.pangding.web.authority.vo.resvo.WithdrawalResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * @Author zhangjinyao
 * @create 2019/6/18 19:53
 */
@RestController
@RequestMapping(value = "/finance",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class FinanceController {
    @Autowired
    private FinanceService financeServiceImpl;

    @PostMapping(value = "/withdrawal")
    public ResponseResult<WithdrawalResVo> withdrawal(@RequestBody WithdrawalReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(financeServiceImpl.withdrawal(reqVo));
    }

}
