package com.pangding.web.report.service.impl;

import com.pangding.web.authority.service.CompanyMoneyService;
import com.pangding.web.report.service.V2IndexService;
import com.pangding.web.vo.order.req.report.DataAnalysisBaseReqVo;
import com.pangding.web.vo.order.req.report.ReportDayFlowReqVo;
import com.pangding.web.vo.order.res.report.AnalysisBaseResVo;
import com.pangding.web.vo.order.res.report.DataAnalysisBaseResVo;
import com.pangding.web.vo.order.res.report.ReportDayFlowResVo;
import com.pangding.web.vo.system.pd.company.CompanyMoneyVo;
import com.pangding.web.vo.system.req.company.CompanyMoneyReqVo;
import com.yanzuoguang.util.helper.CalcHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.MapRow;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class V2IndexServiceImpl implements V2IndexService {

    private final CompanyMoneyService companyMoneyService;

    public V2IndexServiceImpl(CompanyMoneyService companyMoneyService) {
        this.companyMoneyService = companyMoneyService;
    }

    /**
     * 首页顶部汇总数据加载
     * 提现余额取值：判断最后日期 == 当天 取值=当天初始值-当天提现值；不是当天日期，取值= 最终值；
     * 经营流水取值：判断日期==当天，取值=当天收益-当天退款；最后一条日期 不等于 当日，取值 = 0；
     * 交易订单和经营流水取值一样
     *
     * @param reqVo
     * @return
     */
    @Override
    public ReportDayFlowResVo indexDataV2(ReportDayFlowReqVo reqVo) {
        ReportDayFlowResVo result = new ReportDayFlowResVo(0, 0, 0,
                0d, 0d, 0d);

        // 查询公司资金最新的一条数据  可提现余额 当日经营流水 当日交易订单
        CompanyMoneyReqVo companyMoneyReqVo = new CompanyMoneyReqVo();
        companyMoneyReqVo.setCompanyId(reqVo.getCompanyId());
        CompanyMoneyVo companyMoneyLast = companyMoneyService.findLastInfo(companyMoneyReqVo);
        CompanyMoneyVo companyMoneyTotal = companyMoneyService.findTotal(companyMoneyReqVo);
        if (!StringHelper.isEmpty(companyMoneyLast)) {
            // 最新一条数据为当天的数据
            if (companyMoneyLast.getDailyDate().equals(DateHelper.getToday())) {
                double initMoney = companyMoneyLast.getInitMoney();
                double inMoney = companyMoneyLast.getInMoney();
                double refundMoney = companyMoneyLast.getRefundMoney();
                double outMoney = companyMoneyLast.getOutMoney();
                double todayBalance = BigDecimal.valueOf(initMoney)
                        .add(BigDecimal.valueOf(outMoney)).doubleValue();
                if (CalcHelper.add(inMoney, refundMoney) < 0) {
                    double balance = BigDecimal.valueOf(initMoney)
                            .add(BigDecimal.valueOf(refundMoney)).doubleValue();
                    todayBalance = BigDecimal.valueOf(balance)
                            .add(BigDecimal.valueOf(outMoney)).doubleValue();
                }
                result.setTodayBalance(todayBalance);
                double todayMoney = BigDecimal.valueOf(companyMoneyLast.getInMoney())
                        .add(BigDecimal.valueOf(companyMoneyLast.getRefundMoney())).doubleValue();
                result.setTodayPdOrderMoney(todayMoney);
                result.setTodayOrderNum(companyMoneyLast.getInNumber() - companyMoneyLast.getRefundNumber());
            } else {
                result.setTodayBalance(companyMoneyLast.getFinalMoney());
            }
        }
        // 查询汇总金额 提现汇总 经营汇总 交易订单 跨界汇总
        if (!StringHelper.isEmpty(companyMoneyTotal)) {
            // 最新一条数据为当天的数据
            double balance = companyMoneyTotal.getOutMoney() == null ? 0 : Math.abs(companyMoneyTotal.getOutMoney());
            result.setBalance(balance);
            double inMoney = companyMoneyTotal.getInMoney() == null ? 0 : Math.abs(companyMoneyTotal.getInMoney());
            double refundMoney = companyMoneyTotal.getRefundMoney() == null ? 0 : Math.abs(companyMoneyTotal.getRefundMoney());
            double todayMoney = BigDecimal.valueOf(inMoney)
                    .add(BigDecimal.valueOf(refundMoney)).doubleValue();
            result.setPdOrderMoney(todayMoney);

            int inNumber = companyMoneyTotal.getInNumber() == null ? 0 : Math.abs(companyMoneyTotal.getInNumber());
            int refundNumber = companyMoneyTotal.getRefundNumber() == null ? 0 : Math.abs(companyMoneyTotal.getRefundNumber());
            result.setOrderNum(inNumber - refundNumber);
        }
        return result;
    }


    @Override
    public DataAnalysisBaseResVo capitalAndOrderDay(DataAnalysisBaseReqVo req) {

        DataAnalysisBaseResVo res = new DataAnalysisBaseResVo();

        // 经营流水
        List<MapRow> moneyList = new ArrayList<>();
        // 交易订单
        List<MapRow> orderNumList = new ArrayList<>();
        // 获取前三年数据  包含今年
        for (int i = 2; i >= 0; i--) {
            MapRow moneyMap = new MapRow();
            MapRow numMap = new MapRow();
            // 获取当前月份开始时间
            Date nowDay = DateHelper.addYear(DateHelper.getCurDate(), -i);
            Date monthStartDate = DateHelper.getDateTime(DateHelper.getMonthStart(nowDay));
            Date monthEndDate = DateHelper.getDateTime(DateHelper.getMonthEnd(nowDay));
            String monthStart = DateHelper.getDateTimeString(monthStartDate).substring(0, 10);
            String monthEnd = DateHelper.getDateTimeString(monthEndDate).substring(0, 10);
            // 得到该月有多少天
            long time1 = DateHelper.betweenDay(DateHelper.getDateTime(monthStart), DateHelper.getDateTime(monthEnd));
            // 查询列表
            CompanyMoneyReqVo companyMoneyReqVo = new CompanyMoneyReqVo();
            companyMoneyReqVo.setCompanyId(req.getCompanyId());
            companyMoneyReqVo.setStartDate(monthStart);
            companyMoneyReqVo.setEndDate(monthEnd);
            List<CompanyMoneyVo> companyMoneyVoList = companyMoneyService.findCompanyMoneyList(companyMoneyReqVo);

            for (int j = 0; j <= time1; j++) {
                if (j > 0) {
                    monthStartDate = DateHelper.addDay(monthStartDate, 1);
                    monthStart = DateHelper.getDateTimeString(monthStartDate).substring(0, 10);
                }
                if (companyMoneyVoList.size() - 1 == time1) {
                    double money = BigDecimal.valueOf(companyMoneyVoList.get(j).getInMoney())
                            .add(BigDecimal.valueOf(companyMoneyVoList.get(j).getRefundMoney())).doubleValue();
                    moneyMap.put(monthStart, money);
                    int number = companyMoneyVoList.get(j).getInNumber() - companyMoneyVoList.get(j).getRefundNumber();
                    numMap.put(monthStart, number);
                } else {
                    if (companyMoneyVoList.size() > 0) {
                        for (CompanyMoneyVo companyMoneyVo : companyMoneyVoList) {
                            if (monthStart.equals(companyMoneyVo.getDailyDate())) {
                                double money = BigDecimal.valueOf(companyMoneyVo.getInMoney())
                                        .add(BigDecimal.valueOf(companyMoneyVo.getRefundMoney())).doubleValue();
                                int number = companyMoneyVo.getInNumber() - companyMoneyVo.getRefundNumber();
                                moneyMap.put(monthStart, money);
                                numMap.put(monthStart, number);
                                break;
                            } else {
                                moneyMap.put(monthStart, 0);
                                numMap.put(monthStart, 0);
                            }
                        }
                    } else {
                        moneyMap.put(monthStart, 0);
                        numMap.put(monthStart, 0);
                    }
                }
            }
            moneyList.add(moneyMap);
            orderNumList.add(numMap);
        }
        getTotal(req, res, 1);
        res.setMoneyList(moneyList);
        res.setOrderList(orderNumList);
        return res;
    }


    public void getTotal(DataAnalysisBaseReqVo req, DataAnalysisBaseResVo res, int type) {
        // 获取当前年 开始时间 结束时间
        Date nowDay = DateHelper.getCurDate();
        Date startDate = DateHelper.getDateTime(DateHelper.getYearStart(nowDay));
        Date endDate = DateHelper.getDateTime(DateHelper.getYearEnd(nowDay));
        if (type == 1) {
            // 月
            startDate = DateHelper.getDateTime(DateHelper.getMonthStart(nowDay));
            endDate = DateHelper.getDateTime(DateHelper.getMonthEnd(nowDay));
        }
        String yearStart = DateHelper.getDateTimeString(startDate).substring(0, 10);
        String yearEnd = DateHelper.getDateTimeString(endDate).substring(0, 10);
        CompanyMoneyReqVo companyMoneyReqVo = new CompanyMoneyReqVo();
        companyMoneyReqVo.setCompanyId(req.getCompanyId());
        companyMoneyReqVo.setStartDate(yearStart);
        companyMoneyReqVo.setEndDate(yearEnd);

        CompanyMoneyVo companyMoneyTotal = companyMoneyService.findTotal(companyMoneyReqVo);
        if (!StringHelper.isEmpty(companyMoneyTotal)) {
            double inMoney = StringHelper.isEmpty(companyMoneyTotal.getInMoney()) ? 0 : companyMoneyTotal.getInMoney();
            double refundMoney = StringHelper.isEmpty(companyMoneyTotal.getRefundMoney()) ? 0 : companyMoneyTotal.getRefundMoney();
            double money = BigDecimal.valueOf(inMoney)
                    .add(BigDecimal.valueOf(refundMoney)).doubleValue();
            res.setCapitalTotal(money);
            int inNumber = StringHelper.isEmpty(companyMoneyTotal.getInNumber()) ? 0 : companyMoneyTotal.getInNumber();
            int refundNumber = StringHelper.isEmpty(companyMoneyTotal.getRefundNumber()) ? 0 : companyMoneyTotal.getRefundNumber();
            int number = inNumber - refundNumber;
            res.setOrderNum(number);
        }
    }

    @Override
    public DataAnalysisBaseResVo capitalAndOrderMonth(DataAnalysisBaseReqVo req) {
        DataAnalysisBaseResVo res = new DataAnalysisBaseResVo();
        // 经营流水
        List<MapRow> moneyList = new ArrayList<>();
        // 交易订单
        List<MapRow> orderNumList = new ArrayList<>();
        // 获取前三年数据  包含今年
        for (int i = 2; i >= 0; i--) {
            MapRow moneyMap = new MapRow();
            MapRow numMap = new MapRow();

            // 获取当前年 开始时间 结束时间
            Date nowDay = DateHelper.addYear(DateHelper.getCurDate(), -i);
            Date yserStartDate = DateHelper.getDateTime(DateHelper.getYearStart(nowDay));
            Date yesrEndDate = DateHelper.getDateTime(DateHelper.getYearEnd(nowDay));
            String yearStart = DateHelper.getDateTimeString(yserStartDate).substring(0, 10);
            String yearEnd = DateHelper.getDateTimeString(yesrEndDate).substring(0, 10);

            // 得到该年有多少个月
            long time1 = DateHelper.getMonthBetween(DateHelper.getDateTime(yearStart), DateHelper.getDateTime(yearEnd)) + 1;

            CompanyMoneyReqVo companyMoneyReqVo = new CompanyMoneyReqVo();
            companyMoneyReqVo.setCompanyId(req.getCompanyId());
            companyMoneyReqVo.setStartDate(yearStart);
            companyMoneyReqVo.setEndDate(yearEnd);
            List<CompanyMoneyVo> companyMoneyVoList = companyMoneyService.findCompanyMoneyTotalMonthList(companyMoneyReqVo);

            for (int j = 0; j < time1; j++) {
                String month = DateHelper.getDateTimeString(DateHelper.addMonth(yserStartDate, +j)).substring(0, 7);
                if (companyMoneyVoList.size() == time1) {
                    double money = BigDecimal.valueOf(companyMoneyVoList.get(j).getInMoney())
                            .add(BigDecimal.valueOf(companyMoneyVoList.get(j).getRefundMoney())).doubleValue();
                    moneyMap.put(month, money);
                    int number = companyMoneyVoList.get(j).getInNumber() - companyMoneyVoList.get(j).getRefundNumber();
                    numMap.put(month, number);
                } else {
                    if (companyMoneyVoList.size() > 0) {
                        for (CompanyMoneyVo companyMoneyVo : companyMoneyVoList) {
                            String dailyDate = companyMoneyVo.getDailyDate().substring(0, 7);
                            if (dailyDate.equals(month)) {
                                double money = BigDecimal.valueOf(companyMoneyVo.getInMoney())
                                        .add(BigDecimal.valueOf(companyMoneyVo.getRefundMoney())).doubleValue();
                                int number = companyMoneyVo.getInNumber() - companyMoneyVo.getRefundNumber();
                                moneyMap.put(month, money);
                                numMap.put(month, number);
                                break;
                            } else {
                                moneyMap.put(month, 0);
                                numMap.put(month, 0);
                            }
                        }
                    } else {
                        moneyMap.put(month, 0);
                        numMap.put(month, 0);
                    }
                }
            }
            moneyList.add(moneyMap);
            orderNumList.add(numMap);

        }
        getTotal(req, res, 2);
        res.setMoneyList(moneyList);
        res.setOrderList(orderNumList);

        return res;
    }

}
