package com.pangding.web.authority.feign;

import com.pangding.web.authority.vo.reqvo.CompanyScenicInfoReqVo;
import com.pangding.web.authority.vo.reqvo.MerchantCreateReqVo;
import com.pangding.web.vo.product.pd.merchant.MerchantVo;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @Author zhangjinyao
 * @create 2019/5/22 11:55
 */
@FeignClient(value = "pd-scenic")
@RequestMapping(value = "/scenic")
public interface StoreFeign {
    /**
     * 新建景区
     * @param req
     * @return
     */
    @RequestMapping("/merchantCreate")
    ResponseResult<String> merchantCreate(@RequestBody MerchantCreateReqVo req);

    /**
     * 通过公司还是id获取商户信息
     *
     * @param req
     * @return
     */
    @RequestMapping("/getCompanyScenicInfo")
    ResponseResult<MerchantVo> getCompanyScenicInfo(@RequestBody CompanyScenicInfoReqVo req);
}
