package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.TokenDao;
import com.pangding.web.authority.service.TokenService;
import com.pangding.web.authority.vo.LoginVo;
import com.yanzuoguang.util.helper.JsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 登录写入服务类
 *
 * @author 颜佐光
 */
@Component
@Transactional(rollbackFor = Exception.class)
public class TokenServiceImpl implements TokenService {

    @Autowired
    private TokenDao tokenDao;

    /**
     * 保存接口请求日志
     *
     * @param loginVo
     */
    @Override
    public String save(LoginVo loginVo) {
        LoginVo to = tokenDao.load(loginVo, LoginVo.class);
        if (JsonHelper.compare(to,loginVo)) {
            return to.getToken();
        } else if (to != null) {
            return tokenDao.update(loginVo);
        } else {
            return tokenDao.create(loginVo);
        }
    }

    /**
     * 保存接口请求日志
     *
     * @param loginVo 请求数据
     * @retur 保存主键
     */
    @Override
    public LoginVo load(LoginVo loginVo) {
        return tokenDao.load(loginVo, LoginVo.class);
    }

    /**
     * 保存接口请求日志
     *
     * @param loginVo 请求数据
     * @retur 保存主键
     */
    @Override
    public int remove(LoginVo loginVo) {

        return tokenDao.remove(loginVo);
    }

}
