package com.pangding.web.authority.controller;


import com.pangding.web.authority.service.AuthorityService;
import com.pangding.web.authority.vo.AuthorityVo;
import com.pangding.web.authority.vo.reqvo.ListAuthorityReqVo;
import com.pangding.web.authority.vo.reqvo.WebAuthorityReqVo;
import com.pangding.web.authority.vo.reqvo.WebAuthorityResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping("/authority")
public class AuthorityController {

    @Autowired
    AuthorityService authorityServiceImpl;

    /**
     * 新增权限
     * @param authorityVo
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult saveAuthority(@RequestBody AuthorityVo authorityVo){
        CheckerHelper.newInstance()
                .notBlankCheck("authorityName",authorityVo.getName())
                .notBlankCheck("authorityUrl",authorityVo.getUrl())
                .notBlankCheck("type",authorityVo.getType())
                .notBlankCheck("alias",authorityVo.getAlias())
                .notBlankCheck("openMode",authorityVo.getOpenMode())
                .notBlankCheck("remark",authorityVo.getRemark())
                .checkException();
        authorityServiceImpl.save(authorityVo);
        return new ResponseResult();
    }

    /**
     * 修改权限信息
     * @param authorityVo
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult updateAuthority(@RequestBody AuthorityVo authorityVo){
        CheckerHelper.newInstance()
                .notBlankCheck("authorityName",authorityVo.getName())
                .notBlankCheck("authorityUrl",authorityVo.getUrl())
                .notBlankCheck("type",authorityVo.getType())
                .notBlankCheck("alias",authorityVo.getAlias())
                .notBlankCheck("openMode",authorityVo.getOpenMode())
                .notBlankCheck("remark",authorityVo.getRemark())
                .checkException();
        authorityServiceImpl.update(authorityVo);
        return new ResponseResult();
    }

    /**
     * 查询权限列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<WebAuthorityResVo>> listAuthoritys(ListAuthorityReqVo reqVo){
        return ResponseResult.result(authorityServiceImpl.getWebAuthorityResVoList(reqVo));
    }

    /**
     * 查询一级权限
     * @return
     */
    @RequestMapping(value = "/firstLevel", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<WebAuthorityResVo>> parentAuthoritys(ListAuthorityReqVo reqVo){
        reqVo.setLevelOne("one");
        return ResponseResult.result(authorityServiceImpl.getWebAuthorityResVoList(reqVo));
    }

    /**
     * 根据ID查询权限
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/role", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<AuthorityVo> authority(@RequestBody WebAuthorityReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("anthorityId",reqVo.getId())
                .checkException();
        return ResponseResult.result(authorityServiceImpl.getAuthorityById(reqVo));
    }

    /**
     * 删除权限
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult delete(@RequestBody WebAuthorityReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("anthorityId",reqVo.getId())
                .checkException();
        authorityServiceImpl.deleteAuthorityById(reqVo);
        return new ResponseResult();

    }
}


