package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyDao;
import com.pangding.web.authority.vo.CompanyVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:25
 */
@Component
public class CompanyDaoImpl extends BaseDaoImpl implements CompanyDao {

    private static final String CHECK_PHONE = "CHECK_PHONE";

    @Override
    protected void init() {

        register(CompanyVo.class);

        table.addExist(CHECK_PHONE,"contact_phone");
    }

    @Override
    public void checkPhone(CompanyVo companyVo) {
        this.checkExist(CHECK_PHONE,companyVo,"电话号码已存在");
    }
}
