package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.RoleDao;
import com.pangding.web.authority.dao.RoleAuthorityDao;
import com.pangding.web.authority.dao.AuthorityDao;
import com.pangding.web.authority.dao.UserRoleDao;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.RoleService;
import com.pangding.web.authority.vo.*;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangjinyao
 */
@Service
public class RoleServiceImpl implements RoleService {

    @Autowired
    RoleDao roleDao;

    @Autowired
    UserRoleDao userRoleDaoImpl;

    @Autowired
    RoleAuthorityDao roleAuthorityDaoImpl;

    @Autowired
    AuthorityDao authorityDaoImpl;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveRole(WebRoleReqVo webRoleReqVo) {
        RoleVo roleVo = webRoleReqVo;
        this.checkNameExist(roleVo);
        webRoleReqVo.setId(StringHelper.getNewID());

        roleDao.create(roleVo);
        List<String> authorityIds = webRoleReqVo.getAuthorityIds();
        if (authorityIds != null && !authorityIds.isEmpty()){
            for (String authorityId : authorityIds) {
                RoleAuthorityVo roleAuthorityRelation = new RoleAuthorityVo();
                roleAuthorityRelation.setAuthorityId(authorityId);
                roleAuthorityRelation.setRoleId(webRoleReqVo.getId());
                roleAuthorityRelation.setId(StringHelper.getNewID());
                roleAuthorityDaoImpl.create(roleAuthorityRelation);
            }
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateRole(WebRoleReqVo webRoleReqVo) {
        RoleVo roleVo = webRoleReqVo;
        this.checkNameExist(roleVo);

        roleDao.update(roleVo);
        RoleAuthorityGetReqVo reqVo = new RoleAuthorityGetReqVo();
        reqVo.setRoleId(webRoleReqVo.getId());
        List<RoleAuthorityVo> roleAuthorityList = roleAuthorityDaoImpl.getRoleAuthorityList(reqVo);
        if (roleAuthorityList != null && !roleAuthorityList.isEmpty()){
            for (RoleAuthorityVo roleAuthorityRelation:roleAuthorityList) {
                roleAuthorityDaoImpl.remove(roleAuthorityRelation);
            }
        }
        List<String> authorityIds = webRoleReqVo.getAuthorityIds();
        if (authorityIds != null && !authorityIds.isEmpty()){
            for (String authorityId : authorityIds) {
                RoleAuthorityVo roleAuthorityRelation = new RoleAuthorityVo();
                roleAuthorityRelation.setAuthorityId(authorityId);
                roleAuthorityRelation.setRoleId(webRoleReqVo.getId());
                roleAuthorityRelation.setId(StringHelper.getNewID());
                roleAuthorityDaoImpl.create(roleAuthorityRelation);
            }
        }

    }

    @Override
    public WebRoleResVo getRoleById(WebRoleReqVo webRoleReqVo) {
        RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
        roleGetReqVo.setId(webRoleReqVo.getId());
        RoleVo roleVo = roleDao.getRoleById(roleGetReqVo);
        if (roleVo == null){
            throw new CodeException("未找到该角色");
        }
        List<AuthorityVo> authorityList = this.getAuthorityListByRoleId(webRoleReqVo.getId());
        return this.makeResVo(roleVo,authorityList);
    }

    @Override
    public RoleVo getRoleByName(String name) {
        RoleGetReqVo getRoleByRoleNameReqVo = new RoleGetReqVo();
        getRoleByRoleNameReqVo.setName(name);
        return roleDao.getRoleByRoleName(getRoleByRoleNameReqVo);
    }

    @Override
    public void checkNameExist(RoleVo roleVo){
        roleDao.checkNameExist(roleVo);
    }

    @Override
    public PageSizeData<RoleVo> getRoleVoList(ListRoleReqVo req) {

        PageSizeData<RoleVo> roleVoPageSizeData = roleDao.getRoleVoList(req);
        if (roleVoPageSizeData.getList() == null || roleVoPageSizeData.getList().isEmpty()){
            throw new CodeException("没有更多权限");
        }
        return roleVoPageSizeData;
    }

    @Override
    public PageSizeData<WebRoleResVo> getWebRoleResVoList(ListRoleReqVo req) {
        PageSizeData<RoleVo> roleVoPageSizeData = this.getRoleVoList(req);
        PageSizeData<WebRoleResVo> webRoleResVoPageSizeData = new PageSizeData();
        List<RoleVo> roleVoList = roleVoPageSizeData.getList();
        List<WebRoleResVo> webRoleResVoList = new ArrayList(roleVoList.size());
        for (RoleVo roleVo:roleVoList) {
            WebRoleResVo resVo = new WebRoleResVo();
            List<AuthorityVo> authorityVoList = this.getAuthorityListByRoleId(roleVo.getId());

            resVo.setAuthorityList(authorityVoList);
            resVo.setId(roleVo.getId());
            resVo.setName(roleVo.getName());
            resVo.setPid(roleVo.getPid());
            resVo.setRemark(roleVo.getRemark());

            webRoleResVoList.add(resVo);
        }
        webRoleResVoPageSizeData.setPageTotal(roleVoPageSizeData.getPageTotal());
        webRoleResVoPageSizeData.setList(webRoleResVoList);
        webRoleResVoPageSizeData.setPageIndex(roleVoPageSizeData.getPageIndex());
        webRoleResVoPageSizeData.setPageSize(roleVoPageSizeData.getPageSize());

        return webRoleResVoPageSizeData;
    }

    @Override
    public List<AuthorityVo> getAuthorityListByRoleId(String roleId) {
        RoleAuthorityGetReqVo reqVo = new RoleAuthorityGetReqVo();
        reqVo.setRoleId(roleId);
        List<RoleAuthorityVo> roleAuthorityRelationList = roleAuthorityDaoImpl.getRoleAuthorityList(reqVo);
        if (roleAuthorityRelationList != null && !roleAuthorityRelationList.isEmpty()){
            List<AuthorityVo> authorityList = new ArrayList(roleAuthorityRelationList.size());
            for (RoleAuthorityVo roleAuthorityRelation:roleAuthorityRelationList) {
                AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
                authorityGetReqVo.setId(roleAuthorityRelation.getAuthorityId());
                AuthorityVo authorityVo = authorityDaoImpl.load(authorityGetReqVo,AuthorityVo.class);
                authorityList.add(authorityVo);
            }
            return authorityList;
        }
        return null;
    }

    @Override
    public String getAuthorityNameByAuthorityId(String authorityId) {
        AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
        authorityGetReqVo.setId(authorityId);
        AuthorityVo authorityVo = authorityDaoImpl.getAuthority(authorityGetReqVo);
        return authorityVo.getName();
    }

    @Override
    public WebRoleResVo makeResVo(RoleVo roleVo, List<AuthorityVo> authorityList) {
        WebRoleResVo resVo = new WebRoleResVo();
        resVo.setId(roleVo.getId());
        resVo.setName(roleVo.getName());
        resVo.setPid(roleVo.getPid());
        resVo.setRemark(roleVo.getRemark());
        resVo.setAuthorityList(authorityList);
        return resVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteRole(RoleVo roleVo) {

        roleDao.remove(roleVo);

        UserRoleGetReqVo userRoleGetReqVo = new UserRoleGetReqVo();
        userRoleGetReqVo.setRoleId(roleVo.getId());
        List<UserRoleVo> userRoleList = userRoleDaoImpl.getUserRoleList(userRoleGetReqVo);
        if (userRoleList != null && !userRoleList.isEmpty()){
            for (UserRoleVo userRoleRelation:userRoleList) {
                userRoleDaoImpl.remove(userRoleRelation);
            }
        }

        RoleAuthorityGetReqVo reqVo = new RoleAuthorityGetReqVo();
        reqVo.setRoleId(roleVo.getId());
        List<RoleAuthorityVo> roleAuthorityList = roleAuthorityDaoImpl.getRoleAuthorityList(reqVo);
        if (roleAuthorityList != null && !roleAuthorityList.isEmpty()){
            for (RoleAuthorityVo roleAuthority:roleAuthorityList) {
                roleAuthorityDaoImpl.remove(roleAuthority);
            }
        }

        RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
        roleGetReqVo.setId(roleVo.getId());
        List<RoleVo> childList = roleDao.getChild(roleGetReqVo);
        for (RoleVo child:childList) {
            this.deleteRole(child);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(WebRoleReqVo webRoleReqVo) {
        RoleVo roleVo = this.getRoleById(webRoleReqVo);
        this.deleteRole(roleVo);
    }
}
