package com.pangding.web.demo.web;

import com.pangding.web.demo.feign.DemoLogFeign;
import com.pangding.web.demo.service.DemoService;
import com.pangding.web.demo.vo.tbd.DemoVo;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 日志操作控制类
 */
@RestController
@RequestMapping("/demo")
public class DemoController {

    @Autowired
    private DemoService logsService;

    @Autowired
    private DemoLogFeign demoLogFeign;

    /**
     * 保存演示DEMO
     *
     * @param req
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult save(@RequestBody DemoVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("name", req.getName())
                .checkException(req);
        return ResponseResult.result(logsService.create(req));
    }

    /**
     * 保存演示DEMO
     *
     * @param req
     */
    @RequestMapping(value = "/save_exception", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult save_exception(@RequestBody DemoVo req) {
        throw new CodeException("01", "异常错误");
    }

    /**
     * 保存演示DEMO
     *
     * @param req
     */
    @RequestMapping(value = "/log", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> log_exception(@RequestBody LogVo req) {
        demoLogFeign.save(req);
        return ResponseResult.result("保存成功");
    }

    /**
     * 查询
     * @param req
     * @return
     */
    @RequestMapping(value = "/query", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<DemoVo>> query(@RequestBody PageSizeReqVo req){
        return ResponseResult.result(logsService.query(req));
    }
}
