package com.pangding.web.tright.service.impl;

import com.pangding.web.tright.dao.RoleDao;
import com.pangding.web.tright.dto.RoleDto;
import com.pangding.web.tright.service.RoleService;
import com.pangding.web.tright.vo.RoleVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class RoleServiceImpl implements RoleService {

    @Autowired
    RoleDao roleDao;
    @Override
    public void saveRole(RoleDto roleDto) {
        RoleVo role = roleDto;
        if (role.getTrId() != null) {// 修改
            RoleVo r = roleDao.getRole(role.getRoleName());
            if (r != null && r.getTrId() != role.getTrId()) {
                throw new IllegalArgumentException(role.getRoleName() + "已存在");
            }

            roleDao.update(role);
        } else {// 新增
            RoleVo r = roleDao.getRole(role.getRoleName());
            if (r != null) {
                throw new IllegalArgumentException(role.getRoleName() + "已存在");
            }
            roleDao.save(role);
        }
        saveRoleTright(role.getTrId(), roleDto.getTrightIds());
    }

    private void saveRoleTright(Long roleId, List<Long> trights) {
        roleDao.deleteRoleTright(roleId);
        trights.remove(0L);
        if (!CollectionUtils.isEmpty(trights)) {
            roleDao.saveRoleTright(roleId, trights);
        }
    }

    @Override
    public void deleteRole(Long id) {
        roleDao.deleteRoleUser(id);
        roleDao.deleteRole(id);
    }
}
